<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
                              
    <xsl:variable name="multi-value-separator"><xsl:text>
</xsl:text></xsl:variable>

    <xsl:template match="/export">
        <csv>
            <xsl:apply-templates select="header"/>
            <xsl:apply-templates select="rules/rule" mode="rule-row"/>
        </csv>
    </xsl:template>
    
    <xsl:template match="header">
        <row>
            <xsl:apply-templates select="column" mode="header"/>
        </row>
    </xsl:template>

    <xsl:template match="column" mode="header">
        <cell><xsl:value-of select="." /></cell>
	</xsl:template>
	
	<xsl:template match="rule" mode="rule-row">
        <row>
            <xsl:apply-templates select="column" mode="rule-row"/>
        </row>
    </xsl:template>
    
    <xsl:template match="column" mode="rule-row">
        <cell>
            <xsl:for-each select="value">
                <xsl:value-of select="." />
                <xsl:if test="position() != last()"><xsl:value-of select="$multi-value-separator"/></xsl:if>
            </xsl:for-each>
        </cell>
    </xsl:template>
</xsl:stylesheet>
