<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:cms="http://ametys.org/cms/3.0"
                xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                exclude-result-prefixes="i18n docbook ametys exslt">
    
    <xsl:import href="docbookenhancement://docbook2html.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/functions.xsl" />
    
    <xsl:variable name="lang" select="ametys:lang()" />
    <xsl:variable name="canEditRule" select="/thematics/@canEditRule" />
    
    <xsl:template match="/">
        <html>
            <head>
                <xsl:call-template name="rules-preview-js" />
                <xsl:call-template name="rules-preview-css" />
            </head>
            <body>
                <xsl:call-template name="rules-preview" />
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="rules-preview-js">
        <script src="{ametys:uriPrefix()}/plugins/jquery/resources/js/jquery.js"/>
        <script src="{ametys:uriPrefix()}/plugins/jquery-ui/resources/js/jquery-ui.js"/>
        <xsl:if test="$lang != 'en'">
            <script src="{ametys:uriPrefix()}/plugins/jquery-ui/resources/js/i18n/datepicker-{$lang}.js"/>
        </xsl:if>
        <script type="text/javascript">
            $j = jQuery.noConflict();
        </script>
        <script type="text/javascript">
            $j( document ).ready(function() {
                <xsl:if test="/thematics/container/@thematicId">
                    $j(".selected").removeClass("selected");
                    $j("#<xsl:value-of select="/thematics/container/@thematicId" />").attr("open", true);
                    $j("#<xsl:value-of select="/thematics/container/@thematicId" />").addClass("selected");
                    <xsl:choose>
                        <xsl:when test="/thematics/container/@ruleId">
                            $j("#<xsl:value-of select="/thematics/container/@ruleId" />").addClass("selected");
                            $j([document.documentElement, document.body]).animate({
                                scrollTop: $j("#<xsl:value-of select="/thematics/container/@ruleId" />").offset().top - 50
                            }, 0);
                        </xsl:when>
                        <xsl:otherwise>
                            $j([document.documentElement, document.body]).animate({
                                scrollTop: $j("#<xsl:value-of select="/thematics/container/@thematicId" />").offset().top - 50
                            }, 0);
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            });
        
            function selectThematicElement(containerId, thematicCode, thematicType, ruleCode, ruleType, derogable, derogated)
            {
                $j('details').click(function (event) {
                    $j('details').not(this).removeAttr("open");  
                });
            
                $j(".selected").removeClass("selected");
                var thematic = $j("#" + thematicCode);
                if (thematic)
                {
                    thematic.addClass("selected");
                    if (ruleCode)
                    {
                        $j("#" + ruleCode).addClass("selected");
                    }
                }
                parent.Ametys.plugins.odf.pilotage.ui.UIRules.sendSelection(containerId, thematicCode, thematicType, ruleCode, ruleType, derogable || false, derogated || false);
            }
            
            function derogateRule(containerId, thematicCode, ruleCode)
            {
                parent.Ametys.plugins.odf.pilotage.actions.RuleActions.derogateRule(containerId, thematicCode, ruleCode);
            }
            
        </script>
        
        <xsl:call-template name="rules-preview-additional-js" />
    </xsl:template>
    
    <xsl:template name="rules-preview-additional-js">
        <!-- Template for adding additional js -->
    </xsl:template>
    
    <xsl:template name="rules-preview-css">
        <link rel="stylesheet" href="{ametys:uriPrefix()}/plugins/core-ui/resources/font/ametys/AmetysIcon.css"/>
        <link rel="stylesheet" href="{ametys:uriPrefix()}/plugins/odf/resources/font/odf/OdfIcon.css"/>
        <link rel="stylesheet" href="{ametys:uriPrefix()}/plugins/odf-pilotage/resources/css/tool/RulePreview.css"/>
        <xsl:call-template name="rules-preview-additional-css" />
    </xsl:template>
    
    <xsl:template name="rules-preview-additional-css">
        <!-- Template for adding additional css -->
    </xsl:template>
    
    <xsl:template name="rules-preview">
        <div class="rules-preview">
            <xsl:call-template name="rules-preview-header" />
                
            <div>
                <xsl:variable name="containerId" select="/thematics/container/@id" />
                
                <div class="rules-group">
                    <xsl:call-template name="general-thematics" >
                        <xsl:with-param name="containerId" select="$containerId" />
                    </xsl:call-template>
                </div>
                
                <div class="rules-group">
                    <xsl:call-template name="additional-thematics" >
                        <xsl:with-param name="containerId" select="$containerId" />
                    </xsl:call-template>
                </div>
                
                <div class="rules-group">
                    <xsl:call-template name="specific-thematics" >
                        <xsl:with-param name="containerId" select="$containerId" />
                    </xsl:call-template>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="rules-preview-header">
        <div class="rules-preview-header">
            <div>
                <h1><xsl:value-of select="/thematics/container/title" /></h1>
                <div class="container-info">
                    <div class="info">
                        <span class="info-header"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_CONTAINER_CATALOG" i18n:catalogue="plugin.odf-pilotage"/></span>
                        <xsl:value-of select="/thematics/container/catalog" />
                    </div>
                    <div class="info">
                        <span class="info-header"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_CONTAINER_REGIME" i18n:catalogue="plugin.odf-pilotage"/></span>
                        <xsl:choose><xsl:when test="/thematics/container/mccRegime/@title != ''"><xsl:value-of select="/thematics/container/mccRegime/@title" /></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose>
                    </div>
                    <div class="info">
                        <span class="info-header"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_CONTAINER_SESSIONS" i18n:catalogue="plugin.odf-pilotage"/></span>
                        <xsl:choose><xsl:when test="/thematics/container/mccNbSessions != ''"><xsl:value-of select="/thematics/container/mccNbSessions" /></xsl:when><xsl:otherwise>-</xsl:otherwise></xsl:choose>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="general-thematics">
        <xsl:param name="containerId" />
    
        <div class="group-header">
            <h2><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_RULES" i18n:catalogue="plugin.odf-pilotage"/></h2>
        </div>
        
        <xsl:for-each select="/thematics/general/content">
            <xsl:sort select="cms:getOrder(order)" data-type="number"/>
            <xsl:sort select="title" order="ascending"/>
            
            <xsl:call-template name="thematic" >
                <xsl:with-param name="thematicType">general</xsl:with-param>
                <xsl:with-param name="containerId" select="$containerId" />
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="additional-thematics">
        <xsl:param name="containerId" />
    
        <xsl:if test="/thematics/container-rules/thematics/entry">
            <div class="group-header">
                <h2><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_ADDITIONAL_RULES" i18n:catalogue="plugin.odf-pilotage"/></h2>
            
                <div class="button-actions">
                    <button type="button"
                            class="ametysicon-document28 action-edit" 
                            title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_COPY_COMPLEMENTARY_RULES_LABEL" 
                            i18n:attr="title"
                            onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.copyRulesView('{ametys:escapeJS(/thematics/container/title)}', '{$containerId}', 'thematics-edition')"></button>
                </div>
            </div>
                        
            <xsl:for-each select="/thematics/container-rules/thematics/entry">
                <xsl:call-template name="thematic" >
                    <xsl:with-param name="thematicType">additional</xsl:with-param>
                    <xsl:with-param name="containerId" select="$containerId" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="specific-thematics">
        <xsl:param name="containerId" />
        
        <!-- Template to override if view 'specific-rules' is present -->
    </xsl:template>
    
    <xsl:template name="specific-thematics-header">
        <xsl:param name="containerId" />
        <xsl:param name="title" />
    
        <div class="group-header">
            <h2><xsl:value-of select="$title" /></h2>
            
            <div class="button-actions">
                <button type="button"
                        class="ametysicon-document28 action-edit" 
                        title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_COPY_SPECIFIC_RULES_LABEL" 
                        i18n:attr="title"
                        onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.copyRulesView('{ametys:escapeJS(/thematics/container/title)}', '{$containerId}', 'specific-rules')"></button>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="thematic">
        <xsl:param name="thematicType" />
        <xsl:param name="containerId" />
    
        <xsl:if test="rules/entry[not(status) or status/@value != 'SUSPENDED']">
            <xsl:variable name="thematicCode" select="code" />    
            <details id="{$thematicCode}">
                <xsl:call-template name="thematic-summary" >
                    <xsl:with-param name="thematicType" select="$thematicType" />
                    <xsl:with-param name="containerId" select="$containerId" />
                    <xsl:with-param name="thematicCode" select="$thematicCode" />
                </xsl:call-template>
                <xsl:call-template name="rules">
                    <xsl:with-param name="thematicType" select="$thematicType" />
                    <xsl:with-param name="containerId" select="$containerId" />
                    <xsl:with-param name="thematicCode" select="$thematicCode" />
                </xsl:call-template>
                
                <xsl:call-template name="thematic-end">
                    <xsl:with-param name="thematicType" select="$thematicType" />
                    <xsl:with-param name="containerId" select="$containerId" />
                    <xsl:with-param name="thematicCode" select="$thematicCode" />
                </xsl:call-template>
            </details>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="thematic-summary">
        <xsl:param name="thematicType" />
        <xsl:param name="containerId" />
        <xsl:param name="thematicCode" />

        <summary onclick="selectThematicElement('{$containerId}', '{$thematicCode}', '{$thematicType}')" >
            <span class="thematic-title"><xsl:value-of select="$thematicCode" /><xsl:text> - </xsl:text><xsl:value-of select="title"/></span>
            
            <xsl:if test="$thematicType = 'general'">
                <!-- Get only derogated rules -->
                <xsl:variable name="derogatedRules">
                    <derogated-rules>
                    <xsl:for-each select="rules/entry">
                        <xsl:variable name="ruleCode" select="code" />
                        <xsl:if test="/thematics/container-rules/rules/entry[code = $ruleCode]">
                            <rule code="{$ruleCode}" />
                        </xsl:if>
                    </xsl:for-each>
                    </derogated-rules>
                </xsl:variable>

                <!-- Add derogated or derogable tag -->
                <xsl:choose>
                    <!-- First test if at least one rule is derogated -->
                    <xsl:when test="exslt:node-set($derogatedRules)/derogated-rules/rule">
                        <div class="derogated-thematic"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_DEROGATION" i18n:catalogue="plugin.odf-pilotage"/></div>
                    </xsl:when>
                    <!-- Then test if at least one rule is derogable -->
                    <xsl:when test="rules/entry[(not(status) or status/@value != 'SUSPENDED') and isDerogable = 'true']">
                        <div class="derogeable-thematic"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_DEROGABLE" i18n:catalogue="plugin.odf-pilotage"/></div>
                    </xsl:when>
                    <xsl:otherwise></xsl:otherwise>
                </xsl:choose>
                
                <!-- Add additionnal tag if the thematic has at least one additional rule -->
                <xsl:if test="/thematics/container-rules/rules/entry[thematicCode = $thematicCode]">
                    <div class="additional-thematic">
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_ADDITIONAL" i18n:catalogue="plugin.odf-pilotage"/>
                </div>
                </xsl:if>
                
                <!-- Add dot if the thematic has at least one new or modified rule -->
                <xsl:if test="rules/entry[status/@value = 'NEW' or status/@value = 'MODIFIED']">
                    <span class="modify-dot" title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_MODIFIED" i18n:attr="title"/>
                </xsl:if>
            </xsl:if>
        </summary>
    </xsl:template>
    
    <xsl:template name="thematic-end">
        <xsl:param name="thematicType" />
        <xsl:param name="containerId" />
        <xsl:param name="thematicCode" />
        
        <div class="details-end">
            <xsl:if test="$canEditRule = 'true' and $thematicType = 'general'">
                <div class="button-actions">
                    <button type="button"
                            class="ametysicon-add64 action-create" 
                            title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_ADD_ADDITIONAL_LABEL" 
                            i18n:attr="title"
                            onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.addRule('{$containerId}', '{$thematicCode}')"></button>
                </div>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="rules">
        <xsl:param name="thematicType" />
        <xsl:param name="containerId" />
        <xsl:param name="thematicCode" />
        
        <div class="rules">
            <div class="rules-table">
                <table>
                <xsl:variable name="ruleType"><xsl:choose><xsl:when test="$thematicType = 'additional'">additional</xsl:when><xsl:otherwise>general</xsl:otherwise></xsl:choose></xsl:variable>
            
                <!-- Règles générales avec ou sans dérogation -->
                <xsl:for-each select="rules/entry[not(status) or status/@value != 'SUSPENDED']">
                    <xsl:variable name="ruleCode" select="code" />
                    <xsl:variable name="derogateEntry" select="/thematics/container-rules/rules/entry[code = $ruleCode]" />
                    <xsl:choose>
                        <xsl:when test="$derogateEntry">
                            <xsl:apply-templates select="$derogateEntry" mode="rule">
                                <xsl:with-param name="thematicType" select="$thematicType" />
                                <xsl:with-param name="ruleType" select="$ruleType" />
                                <xsl:with-param name="containerId" select="$containerId" />
                                <xsl:with-param name="thematicCode" select="$thematicCode" />
                                <xsl:with-param name="derogated" select="true()" />
                            </xsl:apply-templates>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="." mode="rule">
                                <xsl:with-param name="thematicType" select="$thematicType" />
                                <xsl:with-param name="ruleType" select="$ruleType" />
                                <xsl:with-param name="containerId" select="$containerId" />
                                <xsl:with-param name="thematicCode" select="$thematicCode" />
                            </xsl:apply-templates>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            
                <!-- Règles additionnelles -->
                <xsl:for-each select="/thematics/container-rules/rules/entry[thematicCode = $thematicCode]">
                    <xsl:apply-templates select="." mode="rule">
                        <xsl:with-param name="thematicType" select="$thematicType" />
                        <xsl:with-param name="ruleType">additional</xsl:with-param>
                        <xsl:with-param name="containerId" select="$containerId" />
                        <xsl:with-param name="thematicCode" select="$thematicCode" />
                    </xsl:apply-templates>
                </xsl:for-each>
            
                </table>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="entry" mode="rule">
        <xsl:param name="thematicType" />
        <xsl:param name="ruleType" />
        <xsl:param name="containerId" />
        <xsl:param name="thematicCode" />
        <xsl:param name="derogated" select="false()" />
    
        <xsl:variable name="derogable" select="isDerogable = 'true' or $derogated" />
        <tr onclick="selectThematicElement('{$containerId}', '{$thematicCode}', '{$thematicType}', '{code}', '{$ruleType}', {$derogable}, {$derogated})" id="{code}">
            <xsl:if test="status/@value = 'SUSPENDED'">
                <xsl:attribute name="class">archived</xsl:attribute>
            </xsl:if>
            <td class="rule-code">
                <span class="code"><xsl:value-of select="code"/></span>
                <xsl:choose>
                    <xsl:when test="status/@value = 'MODIFIED'">
                        <span class="modify-dot" title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_RULE_MODIFIED" i18n:attr="title"/>
                    </xsl:when>
                    <xsl:when test="status/@value = 'NEW'">
	                    <span class="modify-dot" title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_RULE_NEW" i18n:attr="title"/>
                    </xsl:when>
                    <xsl:otherwise></xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <div>
                    <div class="rule-header">
                        <xsl:call-template name="rule-type" >
                            <xsl:with-param name="thematicType" select="$thematicType" />
                            <xsl:with-param name="ruleType" select="$ruleType" />
                            <xsl:with-param name="derogated" select="$derogated" />
                        </xsl:call-template>
                    
                        <xsl:call-template name="rule-actions" >
                            <xsl:with-param name="thematicType" select="$thematicType" />
                            <xsl:with-param name="ruleType" select="$ruleType" />
                            <xsl:with-param name="containerId" select="$containerId" />
                            <xsl:with-param name="thematicCode" select="$thematicCode" />
                            <xsl:with-param name="code" select="code" />
                            <xsl:with-param name="derogated" select="$derogated" />
                            <xsl:with-param name="derogable" select="$derogable" />
                        </xsl:call-template>
                    </div>
                    <p><xsl:apply-templates select="text/docbook:article"/></p>
                    <xsl:if test="motivation/docbook:article/docbook:para">
                        <p class="attribute-title">
                        <xsl:choose>
                            <xsl:when test="$derogated">
                                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_MOTIVATION_DEROGATION" i18n:catalogue="plugin.odf-pilotage"/>
                            </xsl:when>
                            <xsl:when test="$thematicType = 'additional' and $ruleType = 'additional'">
                                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_MOTIVATION_COMPLEMENTARY" i18n:catalogue="plugin.odf-pilotage"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_MOTIVATION_ADDITIONAL" i18n:catalogue="plugin.odf-pilotage"/>
                            </xsl:otherwise>
                        </xsl:choose>
                        </p>
                        <xsl:apply-templates select="motivation/docbook:article"/>
                    </xsl:if>
                </div>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="rule-actions">
        <xsl:param name="thematicType" />
        <xsl:param name="ruleType" />
        <xsl:param name="containerId" />
        <xsl:param name="thematicCode" />
        <xsl:param name="code" />
        <xsl:param name="derogated" />
        <xsl:param name="derogable" />
    
        <xsl:if test="$derogable or ($thematicType = 'general' and $ruleType = 'additional')">
            <div class="button-actions">
                <xsl:if test="$canEditRule = 'true'">
                    <xsl:choose>
                        <xsl:when test="$derogable">
                            <button type="button" 
                                    class="ametysicon-edit45 action-edit" 
                                    title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_DEROGATE_LABEL" 
                                    i18n:attr="title"
                                    onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.derogateRule('{$containerId}', '{$thematicCode}', '{code}')"></button>
                        </xsl:when>
                        <xsl:when test="$thematicType = 'general' and $ruleType = 'additional'">
                            <button type="button" 
                                    class="ametysicon-edit45 action-edit"
                                    title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_EDIT_ADDITIONAL_LABEL" 
                                    i18n:attr="title"
                                    onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.editRule('{$containerId}', '{$thematicCode}', '{code}')"></button>
                        </xsl:when>
                        <xsl:otherwise></xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="($thematicType = 'general' and $ruleType = 'additional') or $derogated">
                    <button type="button" 
                            class="ametysicon-document28 action-edit" 
                            title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_COPY_LABEL" 
                            i18n:attr="title"
                            onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.copyRule('{$containerId}', '{$thematicCode}', '{code}')"></button>
                </xsl:if>
                <xsl:if test="$canEditRule = 'true'">
                    <xsl:choose>
                        <xsl:when test="$derogated">
                            <button type="button" 
                                    class="ametysicon-delete30 action-remove" 
                                    title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_CANCEL_DEROGATE_LABEL" 
                                    i18n:attr="title"
                                    onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.deleteRuleDerogation('{$containerId}', '{$thematicCode}', '{code}')"></button>
                        </xsl:when>
                        <xsl:when test="$thematicType = 'general' and $ruleType = 'additional'">
                            <button type="button" 
                                    class="ametysicon-delete30 action-remove" 
                                    title="plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULES_BUTTON_DELETE_ADDITIONAL_LABEL" 
                                    i18n:attr="title"
                                    onclick="parent.Ametys.plugins.odf.pilotage.actions.RuleActions.deleteRule('{$containerId}', '{code}')"></button>
                        </xsl:when>
                        <xsl:otherwise></xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="rule-type">
        <xsl:param name="thematicType" />
        <xsl:param name="ruleType" />
        <xsl:param name="derogated" />
    
        <xsl:choose>
            <xsl:when test="$derogated">
                <div class="rule-type derogation">
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_DEROGATION" i18n:catalogue="plugin.odf-pilotage"/>
                </div>
            </xsl:when>
            <xsl:when test="$thematicType = 'general' and $ruleType = 'additional'">
                <div class="rule-type additional">
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_ADDITIONAL" i18n:catalogue="plugin.odf-pilotage"/>
                </div>
            </xsl:when>
            <xsl:when test="$ruleType = 'additional'">
                <div class="rule-type additional">
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_COMPLEMENTARY" i18n:catalogue="plugin.odf-pilotage"/>
                </div>
            </xsl:when>
            <xsl:when test="isDerogable = 'true'">
                <div class="rule-type derogable">
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_DEROGABLE" i18n:catalogue="plugin.odf-pilotage"/>
                </div>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
