/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfpilotage.catalog;

import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.odf.catalog.AbstractProgramItemAttributeCopyUpdater;
import org.ametys.odf.course.Course;
import org.ametys.runtime.model.ModelItem;

/**
 * The catalog copy updater to update the skills references in APC courses
 */
public class APCCatalogCopyUpdater extends AbstractProgramItemAttributeCopyUpdater
{
    private static final String[] __PATHES_TO_UPDATE = {
        "mccSession1" + ModelItem.ITEM_PATH_SEPARATOR + "notes" + ModelItem.ITEM_PATH_SEPARATOR + "skills" + ModelItem.ITEM_PATH_SEPARATOR + "skill",
        "mccSession2" + ModelItem.ITEM_PATH_SEPARATOR + "notes" + ModelItem.ITEM_PATH_SEPARATOR + "skills" + ModelItem.ITEM_PATH_SEPARATOR + "skill"
    };
    
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        for (Content copiedContent : copiedContents.values())
        {
            if (copiedContent instanceof Course course)
            {
                for (String path : __PATHES_TO_UPDATE)
                {
                    _updateContentAttribute(course, path, copiedContents);
                }
                course.saveChanges();
            }
        }
    }
}
