/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.plugins.odfpilotage.report.consistency.AnalysisExtensionPoint;
import org.ametys.plugins.odfpilotage.report.consistency.ConsistencyAnalysis;
import org.ametys.plugins.odfpilotage.report.consistency.ConsistencyAnalysisResult;
import org.ametys.plugins.odfpilotage.report.impl.AbstractExtract;
import org.ametys.plugins.odfpilotage.schedulable.AbstractReportSchedulable;
import org.ametys.plugins.odfpilotage.schedulable.OrgUnitConsistencyExtractSchedulable;
import org.ametys.plugins.odfpilotage.schedulable.ProgramConsistencyExtractSchedulable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ConsistencyExtract
extends AbstractExtract {
    public static final String PARAMETER_ANALYSIS = "analysis";
    protected AnalysisExtensionPoint _analysisEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        this._analysisEP = (AnalysisExtensionPoint)((Object)manager.lookup(AnalysisExtensionPoint.ROLE));
        super.service(manager);
    }

    @Override
    public String getType(Map<String, String> reportParameters, boolean shortName) {
        Object type = "coherence";
        if (!shortName && reportParameters != null) {
            type = (String)type + "-";
            type = (String)type + Optional.ofNullable(reportParameters.get(PARAMETER_ANALYSIS)).map(arg_0 -> ((AnalysisExtensionPoint)this._analysisEP).getExtension(arg_0)).map(ConsistencyAnalysis::getShortId).orElse("all");
        }
        return type;
    }

    @Override
    protected boolean isGeneric() {
        return false;
    }

    @Override
    protected boolean isCompatibleSchedulable(AbstractReportSchedulable schedulable) {
        return schedulable instanceof OrgUnitConsistencyExtractSchedulable || schedulable instanceof ProgramConsistencyExtractSchedulable;
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        List analyses = Optional.ofNullable(reportParameters.get(PARAMETER_ANALYSIS)).map(arg_0 -> ((AnalysisExtensionPoint)this._analysisEP).getExtension(arg_0)).map(List::of).orElseGet(() -> this._analysisEP.getExtensionsIds().stream().map(arg_0 -> ((AnalysisExtensionPoint)this._analysisEP).getExtension(arg_0)).toList());
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType(reportParameters, true));
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._saxReport(handler, programItem, analyses);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Coh\u00e9rence' report for program '{}' ({})", new Object[]{((Content)programItem).getTitle(), programItem.getCode(), e});
        }
    }

    private void _saxReport(ContentHandler handler, ProgramItem programItem, List<ConsistencyAnalysis> analyses) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("title", ((Content)programItem).getTitle());
        XMLUtils.startElement((ContentHandler)handler, (String)"programItem", (Attributes)attr);
        for (ConsistencyAnalysis analysis : analyses) {
            XMLUtils.startElement((ContentHandler)handler, (String)PARAMETER_ANALYSIS);
            analysis.getLabel().toSAX(handler, "title");
            ConsistencyAnalysisResult result = analysis.analyze(programItem);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("bgColor", result.getStatus().getBgColor());
            attrs.addCDATAAttribute("fontColor", result.getStatus().getFontColor());
            XMLUtils.startElement((ContentHandler)handler, (String)"status", (Attributes)attrs);
            result.getStatusText().toSAX(handler);
            XMLUtils.endElement((ContentHandler)handler, (String)"status");
            result.getIntroText().toSAX(handler, "intro");
            XMLUtils.startElement((ContentHandler)handler, (String)"columns");
            Map<String, I18nizableText> columns = result.getColumns();
            List<String> indentableColumns = result.getIndentableColumns();
            for (String string : columns.keySet()) {
                AttributesImpl columnAttrs = new AttributesImpl();
                columnAttrs.addCDATAAttribute("name", string);
                columnAttrs.addCDATAAttribute("indentable", String.valueOf(indentableColumns.contains(string)));
                XMLUtils.startElement((ContentHandler)handler, (String)"column", (Attributes)columnAttrs);
                columns.get(string).toSAX(handler);
                XMLUtils.endElement((ContentHandler)handler, (String)"column");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"columns");
            XMLUtils.startElement((ContentHandler)handler, (String)"lines");
            for (Map map : result.getLines()) {
                XMLUtils.startElement((ContentHandler)handler, (String)"line");
                for (Map.Entry entry : map.entrySet()) {
                    Object v = entry.getValue();
                    if (v instanceof I18nizableText) {
                        I18nizableText text = (I18nizableText)v;
                        text.toSAX(handler, (String)entry.getKey());
                        continue;
                    }
                    XMLUtils.createElement((ContentHandler)handler, (String)((String)entry.getKey()), (String)entry.getValue().toString());
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"line");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"lines");
            XMLUtils.endElement((ContentHandler)handler, (String)PARAMETER_ANALYSIS);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"programItem");
    }
}

