/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ametys.core.right.RightManager;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.actions.AbstractProgramItemHistoryAction;
import org.ametys.plugins.odfpilotage.helper.AbstractWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class MCCWorkflowHistoryAction
extends AbstractProgramItemHistoryAction {
    private MCCWorkflowHelper _mccWorkflowHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)smanager.lookup(MCCWorkflowHelper.ROLE));
    }

    @Override
    protected boolean canSeeHistory(ProgramItem programItem) {
        return this._rightManager.currentUserHasRight("ODF_Pilotage_See_MCCHistory_Rights", (Object)programItem) == RightManager.RightResult.RIGHT_ALLOW;
    }

    @Override
    protected ProgramItem getParentProgramItemForHistory(ProgramItem programItem) {
        return this._mccWorkflowHelper.getParentContainerWithHigherMCCStatus(programItem);
    }

    @Override
    protected List<AbstractWorkflowHelper.ODFWorkflowStep> getWorkflowSteps(ProgramItem programItem) {
        ArrayList<AbstractWorkflowHelper.ODFWorkflowStep> workflowSteps = new ArrayList<AbstractWorkflowHelper.ODFWorkflowStep>();
        if (programItem instanceof Container) {
            Container container = (Container)programItem;
            if (RulesManager.isRulesEnabled() && this._mccWorkflowHelper.isRulesValidated(container)) {
                workflowSteps.add(this._mccWorkflowHelper.getRulesMentionValidationStep(container));
            }
            if (this._mccWorkflowHelper.isMCCValidated(container)) {
                workflowSteps.add(this._mccWorkflowHelper.getMCCMentionValidationStep(container));
            }
            if (this._mccWorkflowHelper.isMCCOrgUnitControlled(container)) {
                workflowSteps.add(this._mccWorkflowHelper.getMCCOrgunitControlStep(container));
            }
            if (this._mccWorkflowHelper.isMCCOrgUnitValidated(container)) {
                workflowSteps.add(this._mccWorkflowHelper.getMCCOrgunitValidationStep(container));
            }
            if (this._mccWorkflowHelper.isMCCCFVUControlled(container)) {
                workflowSteps.add(this._mccWorkflowHelper.getMCCCFVUControlStep(container));
            }
            if (this._mccWorkflowHelper.isMCCCFVUValidated(container)) {
                workflowSteps.add(this._mccWorkflowHelper.getMCCCFVUValidationStep(container));
            }
            Collections.sort(workflowSteps, new MCCStepComparator());
        }
        return workflowSteps;
    }

    private static final class MCCStepComparator
    implements Comparator<AbstractWorkflowHelper.ODFWorkflowStep> {
        private MCCStepComparator() {
        }

        @Override
        public int compare(AbstractWorkflowHelper.ODFWorkflowStep s1, AbstractWorkflowHelper.ODFWorkflowStep s2) {
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_CFVU_VALIDATED.name().equals(s1.id())) {
                return -1;
            }
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_CFVU_VALIDATED.name().equals(s2.id())) {
                return 1;
            }
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_CFVU_CONTROLLED.name().equals(s1.id())) {
                return -1;
            }
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_CFVU_CONTROLLED.name().equals(s2.id())) {
                return 1;
            }
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_ORGUNIT_VALIDATED.name().equals(s1.id())) {
                return -1;
            }
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_ORGUNIT_VALIDATED.name().equals(s2.id())) {
                return 1;
            }
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_ORGUNIT_CONTROLLED.name().equals(s1.id())) {
                return -1;
            }
            if (MCCWorkflowHelper.MCCWorkflowStep.MCC_ORGUNIT_CONTROLLED.name().equals(s2.id())) {
                return 1;
            }
            return s1.date().compareTo(s2.date());
        }
    }
}

