/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.cms.clientsideelement.SmartContentClientSideElement;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class PilotageStatusButtonClientSideElement
extends SmartContentClientSideElement {
    protected PilotageStatusHelper _pilotageStatusHelper;
    protected ODFHelper _odfHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._pilotageStatusHelper = (PilotageStatusHelper)((Object)manager.lookup(PilotageStatusHelper.ROLE));
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getStatus(List<String> contentsId, String buttonStatus) {
        Map results = super.getStatus(contentsId);
        List allrightContents = (List)results.get("allright-contents");
        if (!allrightContents.isEmpty()) {
            String contentId = (String)((Map)allrightContents.get(0)).get("id");
            Content content = (Content)this._resolver.resolveById(contentId);
            PilotageStatusHelper.PilotageStatus pilotageStatus = this._pilotageStatusHelper.getPilotageStatus(content);
            PilotageStatusHelper.PilotageStatus buttonPilotageStatus = StringUtils.isNotBlank((CharSequence)buttonStatus) ? PilotageStatusHelper.PilotageStatus.valueOf(buttonStatus) : PilotageStatusHelper.PilotageStatus.NONE;
            results.put("isEnabled", this.isEnable(buttonPilotageStatus, pilotageStatus));
            results.put("isPressed", this.isToggle(buttonPilotageStatus, pilotageStatus));
            results.put("go-back", this._getMainlyGoBackDescription(content));
            results.put("go-back-disabled", this._getMainlyGoBackDisabledDescription(content));
            results.put("go-next", this._getMainlyGoNextDescription(content));
            results.put("go-next-disabled", this._getMainlyGoBackDisabledDescription(content));
        }
        return results;
    }

    protected boolean _hasReadAccess(Content content) {
        return this._rightManager.currentUserHasRight("ODF_Pilotage_See_History_Rights", (Object)content) == RightManager.RightResult.RIGHT_ALLOW;
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.content")
    public LocalDate getValidationDate(String contentId) {
        Content content = (Content)this._resolver.resolveById(contentId);
        PilotageStatusHelper.PilotageStatus pilotageStatus = this._pilotageStatusHelper.getPilotageStatus(content);
        switch (pilotageStatus) {
            case MENTION_VALIDATED: {
                return this._pilotageStatusHelper.getMentionValidationDate(content);
            }
            case ORGUNIT_VALIDATED: {
                return this._pilotageStatusHelper.getOrgUnitValidationDate(content);
            }
            case CFVU_VALIDATED: {
                return this._pilotageStatusHelper.getCFVUValidationDate(content);
            }
        }
        return null;
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.content")
    public List<String> getSharedChildName(String contentId) {
        ArrayList<String> names = new ArrayList<String>();
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(contentId);
        for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
            if (this._odfHelper.getParentAbstractPrograms(child).size() <= 1) continue;
            names.add(this._contentHelper.getTitle((Content)child));
        }
        return names;
    }

    public boolean isEnable(PilotageStatusHelper.PilotageStatus buttonPilotageStatus, PilotageStatusHelper.PilotageStatus contentPilotageStatus) {
        switch (contentPilotageStatus) {
            case NONE: {
                return buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.MENTION_VALIDATED);
            }
            case MENTION_VALIDATED: {
                return buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.MENTION_VALIDATED) || buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.ORGUNIT_VALIDATED);
            }
            case ORGUNIT_VALIDATED: {
                return buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.ORGUNIT_VALIDATED) || buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.CFVU_VALIDATED);
            }
            case CFVU_VALIDATED: {
                return buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.CFVU_VALIDATED);
            }
        }
        return false;
    }

    public boolean isToggle(PilotageStatusHelper.PilotageStatus buttonPilotageStatus, PilotageStatusHelper.PilotageStatus contentPilotageStatus) {
        switch (contentPilotageStatus) {
            case NONE: {
                return false;
            }
            case MENTION_VALIDATED: {
                return buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.MENTION_VALIDATED);
            }
            case ORGUNIT_VALIDATED: {
                return buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.MENTION_VALIDATED) || buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.ORGUNIT_VALIDATED);
            }
            case CFVU_VALIDATED: {
                return buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.MENTION_VALIDATED) || buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.ORGUNIT_VALIDATED) || buttonPilotageStatus.equals((Object)PilotageStatusHelper.PilotageStatus.CFVU_VALIDATED);
            }
        }
        return false;
    }

    @Callable(rights={""})
    public void setPilotageStatus(String contentId, String status, String validationDateAsString, String comment) {
        ModifiableDefaultContent content = (ModifiableDefaultContent)this._resolver.resolveById(contentId);
        if (!this._hasRight((Content)content)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "'tried to edit pilotage status of content '" + contentId + "' without sufficient right");
        }
        PilotageStatusHelper.PilotageStatus pilotageStatus = StringUtils.isNotBlank((CharSequence)status) ? PilotageStatusHelper.PilotageStatus.valueOf(status) : PilotageStatusHelper.PilotageStatus.NONE;
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate validationDate = DateUtils.parseLocalDate((String)validationDateAsString);
        if (validationDate == null && ((validationDate = this.getValidationDate(contentId)) == null || validationDate.isBefore(LocalDate.now()))) {
            validationDate = LocalDate.now();
        }
        this._pilotageStatusHelper.setValidationAttribute(content, validationDate, user, comment, pilotageStatus);
    }

    @Callable(rights={""})
    public void removePilotageStatus(String contentId, String status) {
        ModifiableDefaultContent content = (ModifiableDefaultContent)this._resolver.resolveById(contentId);
        if (!this._hasRight((Content)content)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "'tried to edit pilotage status of content '" + contentId + "' without sufficient right");
        }
        PilotageStatusHelper.PilotageStatus pilotageStatus = StringUtils.isNotBlank((CharSequence)status) ? PilotageStatusHelper.PilotageStatus.valueOf(status) : PilotageStatusHelper.PilotageStatus.NONE;
        this._pilotageStatusHelper.removePilotageStatus(content, pilotageStatus);
    }

    protected I18nizableText _getMainlyGoBackDescription(Content content) {
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("go-back-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
    }

    protected I18nizableText _getMainlyGoBackDisabledDescription(Content content) {
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("go-back-disabled-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
    }

    protected I18nizableText _getMainlyGoNextDescription(Content content) {
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("go-next-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
    }

    protected I18nizableText _getMainlyGoNextDisabledDescription(Content content) {
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("go-next-disabled-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
    }
}

