/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.report.clientsideelement;

import java.io.File;
import java.util.Map;

import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.plugins.core.ui.log.ArchivedLogClientSideElement;
import org.ametys.runtime.util.AmetysHomeHelper;

/**
 * {@link ClientSideElement} to see logs of pilotage reports
 */
public class SeeReportLogClientSideElement extends ArchivedLogClientSideElement
{
    @Override
    @Callable (rights = "ODF_Rights_Pilotage_Tool")
    public Map<String, Object> getLogLines(String logFileName, String filtersJson, Integer limit)
    {
        return super.getLogLines(logFileName, filtersJson, limit);
    }
    
    @Override
    protected File getLogsDirectory()
    {
        return new File(AmetysHomeHelper.getAmetysHome(), "logs/pilotage");
    }
}
