/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Combobox for container number of sessions
 */
Ext.define('Ametys.plugins.odfpilotage.widget.SelectContainerNbSessions', {
    extend: 'Ametys.form.widget.ComboBox',
   
    constructor: function (config)
    {
        config = Ext.apply(config, {
            typeAhead: false,
            
            listeners: {
                scope: this,
                'change': function(cb, newValue, oldValue)
                {
                    //It's ready if no form (grid edition)
                    var isFormReady = !this.form || this.form.isFormReady();
                    if (isFormReady)
                    {
                        if (this._oldValue === undefined) {this._oldValue = oldValue || null};
                     
                        if (JSON.stringify(newValue) != JSON.stringify(this._oldValue))
                        {
                            if (this._alertConfiguration === undefined)
                            {
                                Ametys.data.ServerComm.callMethod({
                                    role: "org.ametys.plugins.odfpilotage.helper.PilotageHelper",
                                    methodName: "getMCCConfiguration",
                                    parameters: [],
                                    callback: {
                                        handler: function (alertConfiguration) {
                                            this._alertConfiguration = alertConfiguration;
                                            this._showWarningMsg();
                                        },
                                        scope: this
                                    }
                                });
                            }
                            else
                            {
                                this._showWarningMsg();
                            }
                            
                        }
                        else
                        {
                            this.clearWarning();
                        }   
                    }
                }
            }
        });
        
        this.callParent(arguments);
    },
    
    /**
     * Show a warning message if the mcc configuration allow it
     * @private
     */
    _showWarningMsg: function()
    {
        let rulesEnabled = this._alertConfiguration.rulesEnabled;
        let nbSessionBlocked = this._alertConfiguration.nbSessionBlocked;
        if (rulesEnabled || nbSessionBlocked)
        {
            let warningMsg = "{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_CONTAINER_NB_SESSION_WIDGET_WARNING_MSG}}";
            warningMsg += "<ul>";
            if (rulesEnabled)
            {
                warningMsg += "<li>{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_CONTAINER_NB_SESSION_WIDGET_RULE_WARNING_MSG}}</li>";
            }
            
            if (nbSessionBlocked)
            {
                warningMsg += "<li>{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_CONTAINER_NB_SESSION_WIDGET_BLOCK_WARNING_MSG}}</li>";
            }
            warningMsg += "</ul>";
            
            this.markWarning(warningMsg);
        }
    }
});
