<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                exclude-result-prefixes="i18n exsl odf"> 
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/params/maquette.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/doc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/maquette/legende2doc.xsl"/>
    
    <xsl:param name="mainOrientation" select="'landscape'"/>
    
    <xsl:variable name="nbColumnsBefore" select="5"/>
    <xsl:variable name="nbColumnsAfter" select="1"/>
    <xsl:variable name="nbColumns" select="$nbColumnsBefore + $nbNatureEnseignement + $nbColumnsAfter"/>
    <xsl:param name="titleColumnPosition" select="2"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-maquette"/>
    </xsl:template>
    
    <xsl:template name="css-styles-maquette">
        body 
        {
            font-size: 7.5pt;
        }
        
        h1, h2, h3
        {
            text-align: center;
        }
        
        h1, h2
        {
            font-size: 15pt;
        }
        
        h4
        {
            font-weight: bold;
            color: darkblue;
        }
        
        table
        {
            width: 100%;
            padding: 0px;
            margin: 0px;
        }
        
        thead
        {
            font-weight: bold;
        }
        
        td 
        { 
            padding: 0px;
            margin: 0px;
            border-bottom:1px solid  #333333;
        }
        
        .border 
        { 
            border-left:1px solid  #333333;
            text-align:center;
        }
        
        .codeEtapePorteuse 
        { 
            border-left:1px solid  #333333;
            text-align:left;
        }
        
        .codeAmetys 
        {
            color: #777777;
        }
        
        .choisirElement
        {
            color: darkblue;
        }
        
        .etapePorteuse
        {
            background-color: #DDDDDD;
        }
        
        .indent0
        { 
            font-size: 9pt;
            margin: 15px 0px 3px 0px;
            width: 100%;
        }
        .choisirIndent1, .indent1
        {
            margin-left: 20px;
            width: 100%;
        }
        .choisirIndent2, .indent2
        {
            margin-left: 40px;
            width: 100%;
        }
        .choisirIndent3, .indent3
        {
            margin-left: 60px;
            width: 100%;
        }
        .choisirIndent4, .indent4
        {
            margin-left: 80px;
            width: 100%;
        }
        .choisirIndent5, .indent5
        {
            margin-left: 100px;
            width: 100%;
        }
        
        .legend-title
        {
            color: #000080;
            font-weight: bold;
            padding-bottom: 3.0pt;
            font-size: 8.0pt;
        }
        
        table.legend td
        {
            vertical-align: middle;
            border: none;
        }
    </xsl:template>
    
    <xsl:template name="doc-title">
        <xsl:apply-templates select="program" mode="title"/>
    </xsl:template>
    
    <xsl:template name="footer">
        <xsl:value-of select="title" />
        <xsl:text> - </xsl:text>
        <xsl:apply-templates select="program|subProgram|container" mode="catalog"/>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="catalog">
        <xsl:value-of select="/report/catalog"/>
    </xsl:template>
    
    <xsl:template name="body">
        <xsl:apply-templates select="program" />
        <xsl:call-template name="legende"/>
    </xsl:template>

    <xsl:template match="program">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <h1 class="h1{$suffix}">
            <xsl:apply-templates select="." mode="title"/>
        </h1>
        <xsl:apply-templates select="subProgram|container|courseList"/>
    </xsl:template>
    
    <xsl:template match="subProgram">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <h2 class="h2{$suffix}">
            <xsl:apply-templates select="." mode="title"/>
        </h2>
        
        <xsl:apply-templates select="subProgram|container|courseList" />
    </xsl:template>
    
    <xsl:template match="container[nature/code = 'annee']">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <h3 class="container{$suffix}">
            <xsl:apply-templates select="." mode="title"/>
        </h3>
        
        <xsl:apply-templates select="subProgram|container|courseList">
            <xsl:with-param name="COD_ETP_YEAR" select="contentId"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="container">
        <xsl:param name="COD_ETP_YEAR" />
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <h4 class="container{$suffix}">
            <xsl:apply-templates select="." mode="title"/>
        </h4>
        
        <xsl:apply-templates select="subProgram|container|courseList">
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="courseList">
        <xsl:param name="COD_ETP_YEAR" />
        
        <table>
            <thead>
                <xsl:call-template name="table-head"/>
            </thead>
            <tbody>
                <xsl:call-template name="table-body">
                    <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
                </xsl:call-template>
            </tbody>
        </table>
        
        <br />
    </xsl:template>
    
    <xsl:template name="table-head">
        <tr>
            <xsl:call-template name="before-course-parts"/>
            <xsl:for-each select="exsl:node-set($naturesEnseignementByCategory)/category">
                <td style="width: 15mm;"><xsl:value-of select="@code"/></td>
            </xsl:for-each>
            <xsl:call-template name="after-course-parts"/>
        </tr>
    </xsl:template>
    
    <xsl:template name="before-course-parts" >
        <td style="width: 20mm;" class="codeAmetys"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CODE_AMETYS"/></td>
        <td/>
        <td style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_NATURE"/></td>
        <td style="width: 10mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ECTS"/></td>
        <td style="width: 10mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_PARTAGE_ABREV"/></td>
    </xsl:template>
    
    <xsl:template name="after-course-parts">
        <td style="width: 50mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ETAPE_PORTEUSE"/></td>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:param name="COD_ETP_YEAR" />
        <xsl:apply-templates select="." mode="child">
            <xsl:with-param name="indent" select="0"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="courseList" mode="child">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        
        <xsl:apply-templates select="." mode="courselist-header">
            <xsl:with-param name="indent" select="$indent"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="course">
            <xsl:with-param name="indent" select="$indent"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="courseList[choiceType/@value = 'OPTIONAL']" mode="courselist-header">
        <xsl:param name="indent"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <tr class="choisirElement{$suffix}">
            <td colspan="{$titleColumnPosition - 1}"/>
            <td colspan="{$nbColumns - $titleColumnPosition + 1}">
                <div>
                    <xsl:if test="$indent > 0">
                        <xsl:attribute name="class">choisirIndent<xsl:value-of select="$indent - 1"/></xsl:attribute>
                    </xsl:if>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ENSEIGNEMENTS_FACULTATIFS"/>
                </div>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="courseList[choiceType/@value = 'CHOICE']" mode="courselist-header">
        <xsl:param name="indent"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <tr class="choisirElement{$suffix}">
            <td colspan="{$titleColumnPosition - 1}"/>
            <td colspan="{$nbColumns - $titleColumnPosition + 1}">
                <div>
                    <xsl:if test="$indent > 0">
                        <xsl:attribute name="class">choisirIndent<xsl:value-of select="$indent - 1"/></xsl:attribute>
                    </xsl:if>
                    
                    <xsl:variable name="isPlural"><xsl:if test="current() > 1">S</xsl:if></xsl:variable>
                    <i18n:translate>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CHOICE_ELEMENT{$isPlural}"/>
                        <i18n:param><xsl:value-of select="min" /></i18n:param>
                    </i18n:translate>
                </div>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="courseList" mode="courselist-header"/>
    
    <xsl:template match="course">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        <tr>
            <xsl:if test="etapePorteuse/title != '' and not($COD_ETP_YEAR = etapePorteuse/@id)">
                <xsl:attribute name="class">etapePorteuse</xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="." mode="cell-codeAmetys">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-label">
                <xsl:with-param name="suffix" select="$suffix"/>
                <xsl:with-param name="indent" select="$indent"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-nature">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-ects">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-shared">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-courseParts">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-etapePorteuse">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
        </tr>
        
        <xsl:call-template name="coursesChildren">
            <xsl:with-param name="indent" select="$indent"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:call-template>
    </xsl:template>
    
    
    <xsl:template match="course" mode="cell-codeAmetys">
        <xsl:param name="suffix"/>
       
        <td class="codeAmetys{$suffix}">
            <xsl:choose>
                <xsl:when test="displayCode != ''"><xsl:value-of select="displayCode"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="code" /></xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-codeApogee">
        <xsl:param name="suffix"/>
       
        <td class="course{$suffix}">
            <xsl:value-of select="elpCode" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-label">
        <xsl:param name="suffix"/>
        <xsl:param name="indent"/>
        
        <td class="course{$suffix}">
            <div class="indent{$indent}">
                <xsl:call-template name="courseLabel"/>
            </div>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-nature">
        <xsl:param name="suffix"/>
        
        <td class="border{$suffix}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="courseType/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-ects">
        <xsl:param name="suffix"/>
        
        <td class="border{$suffix}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="odf:getEcts(@id, @path)" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-shared">
        <xsl:param name="suffix"/>
        
        <xsl:variable name="occurences" select="count(parentCourseLists)"/>
        <td class="border{$suffix}">
            <xsl:if test="$occurences > 1">X (<xsl:value-of select="$occurences"/>)</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course"  mode="cell-courseParts">
        <xsl:param name="suffix"/>
        
        <xsl:variable name="currentCourse" select="."/>
        
        <xsl:for-each select="exsl:node-set($naturesEnseignementByCategory)/category">
            <td class="border{$suffix}">
                <xsl:for-each select="item">
                    <xsl:variable name="courseParts" select="$currentCourse/courseParts[nature/@id = current()/@id]"/>
                    <xsl:if test="count($courseParts) > 0">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="sum($courseParts/nbHours)"/>
                        </xsl:call-template>
                        <xsl:if test="@code != ../@code">
                            <xsl:text> </xsl:text>(<xsl:value-of select="@code"/>)
                        </xsl:if>
                        <xsl:if test="position() != last()">
                            <br/>
                        </xsl:if>
                    </xsl:if>
                </xsl:for-each>
            </td>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-etapePorteuse">
        <xsl:param name="suffix"/>
        
        <td class="codeEtapePorteuse{$suffix}">
            <xsl:if test="etapePorteuse/title != ''">
                <xsl:apply-templates select="etapePorteuse" mode="title"/>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template name="coursesChildren">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        <xsl:apply-templates select="courseList" mode="child">
            <xsl:with-param name="indent" select="$indent + 1"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container|etapePorteuse" mode="title">
        <xsl:value-of select="title" />
        
        <xsl:apply-templates select="." mode="title-code-suffix"/>
    </xsl:template>
    
    <xsl:template match="program" mode="title-code-suffix">
        <xsl:if test="displayCode != ''">
            <xsl:text> - </xsl:text>
            <xsl:value-of select="displayCode" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="container[nature/code = 'annee']|etapePorteuse" mode="title-code-suffix">
        <xsl:if test="displayCode != ''">
            <xsl:text> (</xsl:text>
            <xsl:value-of select="displayCode" />
            <xsl:text>)</xsl:text>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="*" mode="title-code-suffix"/>
    
    <xsl:template match="program|subProgram|container|courseList|course" mode="suffix"/>
    
    <xsl:template name="courseLabel">
        <xsl:if test="shortLabel != ''">
            <xsl:value-of select="shortLabel"/><xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="title" />
    </xsl:template>
</xsl:stylesheet>
