/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.I18nUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.cost.CostComputationComponent;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.plugins.odfpilotage.cost.entity.Effectives;
import org.ametys.plugins.odfpilotage.cost.entity.EqTD;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.cost.entity.VolumesOfHours;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.odfpilotage.report.impl.AbstractReport;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SyntheseReport
extends AbstractReport {
    protected CostComputationComponent _costComputationComponent;
    protected I18nUtils _i18nUtils;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._costComputationComponent = (CostComputationComponent)((Object)manager.lookup(CostComputationComponent.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    @Override
    public String getType(Map<String, String> reportParameters, boolean shortName) {
        return "synthese";
    }

    @Override
    public String getDefaultOutputFormat() {
        return "xls";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("xls");
    }

    @Override
    protected void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
        CostComputationData costData = this._costComputationComponent.computeCostsOnOrgUnit(orgUnit, catalog, lang, false);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType(reportParameters, true));
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._reportHelper.saxNaturesEnseignement(handler, this.getLogger());
            this._writeLines(handler, costData, orgUnit);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Synthese' report for orgunit '{}'", (Object)orgUnit.getTitle(), (Object)e);
        }
    }

    private void _writeLines(ContentHandler handler, CostComputationData costData, OrgUnit orgUnit) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"lines");
        Double orgUnitEffective = 0.0;
        Map<Program, Set<Container>> stepsByProgram = this._getStepsByProgram(costData);
        for (Program program : stepsByProgram.keySet()) {
            Double programEffective = 0.0;
            Set<Container> steps = stepsByProgram.get(program);
            for (Container step : steps) {
                programEffective = programEffective + this._writeStepLine(handler, costData, program, step);
            }
            this._writeProgramLine(handler, costData, program, programEffective);
            orgUnitEffective = orgUnitEffective + programEffective;
        }
        this._writeOrgUnitLine(handler, costData, orgUnit, orgUnitEffective);
        XMLUtils.endElement((ContentHandler)handler, (String)"lines");
    }

    private Map<Program, Set<Container>> _getStepsByProgram(CostComputationData costData) {
        String yearId = this._odfHelper.getYearId().orElse(null);
        TreeMap<Content, Set<Container>> stepsByProgram = new TreeMap<Content, Set<Container>>(ReportHelper.CONTENT_TITLE_COMPARATOR);
        for (Program program : costData.getComputedPrograms()) {
            stepsByProgram.put((Content)program, this._getChildrendStepsForProgram(program, yearId));
        }
        return stepsByProgram;
    }

    private Set<Container> _getChildrendStepsForProgram(Program program, String yearId) {
        if (yearId == null) {
            return Set.of();
        }
        return this._getChildrendStepsForProgramItem((ProgramItem)program, yearId).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    private Stream<Container> _getChildrendStepsForProgramItem(ProgramItem programItem, String yearId) {
        if (this._odfHelper.isContainerOfNature(programItem, yearId)) {
            return Stream.of((Container)programItem);
        }
        return this._odfHelper.getChildProgramItems(programItem).stream().flatMap(child -> this._getChildrendStepsForProgramItem((ProgramItem)child, yearId));
    }

    private Double _writeStepLine(ContentHandler handler, CostComputationData costData, Program program, Container step) throws AmetysRepositoryException, SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"line");
        XMLUtils.createElement((ContentHandler)handler, (String)"type", (String)"container");
        XMLUtils.createElement((ContentHandler)handler, (String)"diplome", (String)program.getTitle());
        XMLUtils.createElement((ContentHandler)handler, (String)"annee", (String)step.getTitle());
        Double stepEffective = this._writeValues(handler, costData, (Content)step, program.getName() + "/(.*/)*" + step.getName(), null);
        XMLUtils.endElement((ContentHandler)handler, (String)"line");
        return stepEffective;
    }

    private void _writeProgramLine(ContentHandler handler, CostComputationData costData, Program program, Double effective) throws AmetysRepositoryException, SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"line");
        XMLUtils.createElement((ContentHandler)handler, (String)"type", (String)"program");
        HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
        i18nParams.put("program", new I18nizableText(program.getTitle()));
        XMLUtils.createElement((ContentHandler)handler, (String)"diplome", (String)this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_SYNTHESIS_TOTAL", i18nParams), program.getLanguage()));
        this._writeValues(handler, costData, (Content)program, program.getName(), effective);
        XMLUtils.endElement((ContentHandler)handler, (String)"line");
    }

    private void _writeOrgUnitLine(ContentHandler handler, CostComputationData costData, OrgUnit orgUnit, Double effective) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"line");
        XMLUtils.createElement((ContentHandler)handler, (String)"type", (String)"orgunit");
        XMLUtils.createElement((ContentHandler)handler, (String)"diplome", (String)this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_SYNTHESIS_GRAND_TOTAL"), orgUnit.getLanguage()));
        this._writeValues(handler, costData, (Content)orgUnit, orgUnit.getName(), effective);
        XMLUtils.endElement((ContentHandler)handler, (String)"line");
    }

    private Double _writeValues(ContentHandler handler, CostComputationData costData, Content item, String regexPath, Double effective) throws SAXException {
        ProgramItemData itemData = (ProgramItemData)costData.get(item.getId());
        Double localEffective = effective;
        if (itemData != null) {
            EqTD eqTD;
            Pattern filterPattern = Pattern.compile(regexPath);
            VolumesOfHours volumesOfHours = itemData.getVolumesOfHours();
            if (volumesOfHours != null) {
                for (Map.Entry<String, Double> volumeOfHours : volumesOfHours.getVolumes().entrySet()) {
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("id", volumeOfHours.getKey());
                    XMLUtils.createElement((ContentHandler)handler, (String)"volume", (Attributes)attrs, (String)String.valueOf(volumeOfHours.getValue()));
                }
                XMLUtils.createElement((ContentHandler)handler, (String)"total", (String)String.valueOf(volumesOfHours.getTotal()));
            }
            if ((eqTD = itemData.getEqTD()) != null) {
                Double localEqTD = Optional.ofNullable(eqTD.getLocalEqTD()).map(map -> this._sumValuesWithFilteredName((Map<String, Double>)map, filterPattern)).orElse(0.0);
                XMLUtils.createElement((ContentHandler)handler, (String)"eqtdLocal", (String)String.valueOf(localEqTD));
                Double proratedEqTD = Optional.ofNullable(eqTD.getProratedEqTD()).map(map -> this._sumValuesWithFilteredName((Map<String, Double>)map, filterPattern)).orElse(0.0);
                XMLUtils.createElement((ContentHandler)handler, (String)"eqtdProrated", (String)String.valueOf(proratedEqTD));
            }
            if (localEffective == null) {
                localEffective = Optional.ofNullable(itemData.getEffectives()).map(Effectives::getLocalEffectiveByPath).map(map -> this._sumValuesWithFilteredName((Map<String, Double>)map, filterPattern)).orElse(0.0);
            }
            XMLUtils.createElement((ContentHandler)handler, (String)"effectif", (String)String.valueOf(Math.round(localEffective)));
            Optional heRatio = this._filterMapValuesWithFilteredName(itemData.getHeRatios(), filterPattern).flatMap(Optional::stream).reduce(Double::sum);
            if (heRatio.isPresent()) {
                XMLUtils.createElement((ContentHandler)handler, (String)"heRatio", (String)String.valueOf(heRatio.get()));
            }
        }
        return Optional.ofNullable(localEffective).orElse(0.0);
    }

    private Double _sumValuesWithFilteredName(Map<String, Double> mapToFilterAndSum, Pattern filterPattern) {
        return this._filterMapValuesWithFilteredName(mapToFilterAndSum, filterPattern).reduce(0.0, Double::sum);
    }

    private <T> Stream<T> _filterMapValuesWithFilteredName(Map<String, T> mapToFilter, Pattern filterPattern) {
        return mapToFilter.entrySet().stream().filter(entry -> filterPattern.matcher((CharSequence)entry.getKey()).matches()).map(Map.Entry::getValue);
    }
}

