/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.xslt;

import java.time.LocalDate;
import java.util.ArrayList;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.dom.AmetysNodeList;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class MCCXSLTHelper
implements Serviceable,
LogEnabled {
    protected static AmetysObjectResolver _ametysObjectResolver;
    protected static MCCWorkflowHelper _mccWorkflowHelper;
    protected static Logger _logger;

    public void service(ServiceManager smanager) throws ServiceException {
        _ametysObjectResolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        _mccWorkflowHelper = (MCCWorkflowHelper)((Object)smanager.lookup(MCCWorkflowHelper.ROLE));
    }

    public void enableLogging(Logger logger) {
        _logger = logger;
    }

    public static AmetysNodeList getMCCValidatedPDF(String containerId) {
        try {
            Container container = (Container)_ametysObjectResolver.resolveById(containerId);
            ModelAwareRepeaterEntry entry = _mccWorkflowHelper.getLastMCCValidatedEntry(container);
            if (entry != null) {
                SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                TransformerHandler th = saxTransformerFactory.newTransformerHandler();
                DOMResult result = new DOMResult();
                th.setResult(result);
                th.startDocument();
                XMLUtils.startElement((ContentHandler)th, (String)"value");
                if (entry.hasValue("pdf")) {
                    entry.dataToSAX((ContentHandler)th, "pdf", RepositoryDataContext.newInstance().withDataPath("mcc-validated-pdf[" + entry.getPosition() + "]/pdf"));
                }
                XMLUtils.endElement((ContentHandler)th, (String)"value");
                th.endDocument();
                ArrayList<Node> values = new ArrayList<Node>();
                NodeList childNodes = result.getNode().getFirstChild().getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node n = childNodes.item(i);
                    values.add(n);
                }
                return new AmetysNodeList(values);
            }
        }
        catch (Exception e) {
            _logger.error("An error occurred getting the MCC validated PDF", (Throwable)e);
        }
        return null;
    }

    public static String getMCCCFVUValidationDate(String containerId) {
        Container container = (Container)_ametysObjectResolver.resolveById(containerId);
        LocalDate validationDate = _mccWorkflowHelper.getMCCCFVUValidationDate(container);
        return DateUtils.localDateToString((LocalDate)validationDate);
    }
}

