/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.restriction;

import java.util.ArrayList;

/**
 * Restrictions for a repeater with educational path or for data in a repeater with educational
 */
public class RepeaterWithEducationalPathRestriction extends org.ametys.odf.restriction.RepeaterWithEducationalPathRestriction
{
    @Override
    public void initialize() throws Exception
    {
        super.initialize();
        
        if (_fields.contains(ByEducationalPathAttributesEnumerator.VALUE_MCCSESSIONS))
        {
            _fields = new ArrayList<>(_fields); // Make it modifiable again
            _fields.remove(ByEducationalPathAttributesEnumerator.VALUE_MCCSESSIONS);
            _fields.add("mccSession1");
            _fields.add("mccSession2");
        }
    }
}
