/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.schedulable;

import jakarta.mail.MessagingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.right.RightManager;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.odf.schedulable.ODFSchedulableHelper;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.ReportExtensionPoint;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public abstract class AbstractReportSchedulable
extends AbstractStaticSchedulable
implements Initializable {
    public static final String JOBDATAMAP_EXTENSION_ID_KEY = "extensionId";
    public static final String JOBDATAMAP_OUTPUT_FORMAT_KEY = "outputFormat";
    protected SourceResolver _sourceResolver;
    protected ReportExtensionPoint _reportEP;
    protected ReportHelper _reportHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected I18nUtils _i18nUtils;
    private String _mailFrom;
    private RightManager _rightManager;

    public void initialize() throws Exception {
        this._mailFrom = (String)Config.getInstance().getValue("smtp.mail.from");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        for (Configuration paramConf : configuration.getChild("parameters").getChildren("param")) {
            if (!paramConf.getAttribute("id").equals(JOBDATAMAP_EXTENSION_ID_KEY)) continue;
            Configuration customEnumConf = Optional.of(paramConf).map(c -> c.getChild("enumeration", false)).map(c -> c.getChild("custom-enumerator", false)).orElse(null);
            if (customEnumConf.getChild("schedulable", false) != null) break;
            DefaultConfiguration schedulableConf = (DefaultConfiguration)customEnumConf.getChild("schedulable");
            schedulableConf.setValue(((Object)((Object)this)).getClass().getName());
            ((DefaultConfiguration)customEnumConf).addChild((Configuration)schedulableConf);
            break;
        }
        super.configure(configuration);
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._reportEP = (ReportExtensionPoint)((Object)manager.lookup(ReportExtensionPoint.ROLE));
        this._reportHelper = (ReportHelper)manager.lookup(ReportHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        block17: {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String extensionId = jobDataMap.getString("parameterValues#extensionId");
            PilotageReport report = (PilotageReport)this._reportEP.getExtension(extensionId);
            Request request = ContextHelper.getRequest((Context)this._context);
            request.setAttribute("report", (Object)report);
            request.setAttribute("reportTarget", (Object)this.getTarget());
            request.setAttribute("reportParameters", this.getReportParameters(jobDataMap));
            Source source = null;
            String status = null;
            File file = null;
            try {
                source = this._sourceResolver.resolveURI("cocoon://_plugins/odf-pilotage/pilotage-report.zip");
                try (InputStream is = source.getInputStream();){
                    status = (String)request.getAttribute("reportStatus");
                    if (status != null) break block17;
                    String zipFileName = (String)request.getAttribute("reportZipName");
                    file = new File(this._reportHelper.getPilotageFolder(), zipFileName);
                    FileUtils.deleteQuietly((File)file);
                    file.createNewFile();
                    try (FileOutputStream os = new FileOutputStream(file);){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    status = "SUCCESS";
                }
            }
            catch (Exception e) {
                status = "FAIL";
                throw e;
            }
            finally {
                if (source != null) {
                    this._sourceResolver.release(source);
                }
                this._sendMail(status, report.getLabel(), file);
            }
        }
    }

    public Map<String, ElementDefinition> getParameters() {
        return ODFSchedulableHelper.cleanUnsupportedWidgets((Request)ContextHelper.getRequest((Context)this._context), (Map)super.getParameters());
    }

    public abstract PilotageReport.PilotageReportTarget getTarget();

    public boolean forGenericReports() {
        return true;
    }

    protected Map<String, String> getReportParameters(JobDataMap jobDataMap) {
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        reportParameters.put(JOBDATAMAP_OUTPUT_FORMAT_KEY, jobDataMap.getString("parameterValues#outputFormat"));
        return reportParameters;
    }

    protected void _sendMail(String status, I18nizableText reportLabel, File zipFile) {
        String recipientEmail;
        UserIdentity currentUser = this._currentUserProvider.getUser();
        User recipientUser = Optional.ofNullable(currentUser).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).orElseGet(null);
        if (recipientUser != null && StringUtils.isNotEmpty((CharSequence)(recipientEmail = recipientUser.getEmail()))) {
            String recipientLanguage = (String)StringUtils.defaultIfBlank((CharSequence)recipientUser.getLanguage(), (CharSequence)this._userLanguagesManager.getDefaultLanguage());
            String subject = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MAIL_SUBJECT", Map.of("name", reportLabel)), recipientLanguage);
            try {
                StandardMailBodyHelper.MailBodyBuilder mailBodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MAIL_BODY_TITLE", Map.of("name", reportLabel))).addMessage(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MAIL_BODY_" + status, Map.of("name", reportLabel)));
                if ("SUCCESS".equals(status) && this._rightManager.hasRight(currentUser, "ODF_Rights_Pilotage_Tool", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) {
                    mailBodyBuilder.addMessage(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MAIL_BODY_SUCCESS_PILOTAGE_TOOL")).withLink(this._getPilotageToolUri(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MAIL_BODY_SUCCESS_PILOTAGE_TOOL_LINK"));
                }
                String htmlBody = mailBodyBuilder.withLanguage(recipientLanguage).build();
                List<File> attachments = Optional.ofNullable(zipFile).filter(File::exists).stream().toList();
                this.getLogger().info("Envoi du rapport par mail");
                SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withAttachments(attachments).withRecipient(recipientEmail).withSender(this._mailFrom).sendMail();
            }
            catch (MessagingException | IOException e) {
                this.getLogger().warn("Fail to send email to {}", (Object)recipientEmail, (Object)e);
            }
        }
    }

    protected String _getPilotageToolUri() {
        StringBuilder url = new StringBuilder(HttpUtils.sanitize((String)((String)Config.getInstance().getValue("cms.url"))));
        url.append("/index.html?uitool=uitool-pilotage");
        return url.toString();
    }
}

