/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.catalog;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.ametys.cms.repository.Content;
import org.ametys.odf.catalog.AbstractProgramItemAttributeCopyUpdater;
import org.ametys.odf.catalog.CopyCatalogUpdater;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Container;

/**
 * Implementation of {@link CopyCatalogUpdater} to update additional pilotage attributs after a catalog's copy
 */
public class PilotageAttributeCopyUpdater extends AbstractProgramItemAttributeCopyUpdater
{
    @Override
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        Map<Content, Content> copiedContainers = copiedContents.keySet()
                                                               .stream()
                                                               .filter(Container.class::isInstance)
                                                               .collect(Collectors.toMap(Function.identity(), copiedContents::get));
        
        for (Content copiedContent : copiedContents.values())
        {
            if (copiedContent instanceof Course course)
            {
                _updateContentAttribute(course, "etapePorteuse", copiedContainers); // simple - container
                course.saveChanges();
            }
        }
    }
}
