/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that will be responsible for the content deletion
 * The button will be enabled only if the content is modifiable, not locked, not referenced and user has sufficient rights.
 * @private
 */
Ext.define('Ametys.plugins.odf.pilotage.controller.EditODFPilotageCatalogContentController', {
	extend: 'Ametys.plugins.cms.content.controller.SmartContentController',
	
	constructor: function(config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this.refreshIfMatchingMessage, this);
    },
    
    _getStatus: function (targets)
    {
        // First, we check if there is a reason to disable the controller without the server call
        this.callParent(arguments);
        
	    if (!this.isDisabled())
	    {
            Ametys.plugins.odf.pilotage.helper.ODFPilotageControllerHelper.getRestrictionStatus(this, targets[0], "catalog");
	    }
    }
    
});