/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This button allows to remove a referenced content from its parent in the current selection.
 * The message bus target must have an additionnal parameter "parentNode"
 */
Ext.define('Ametys.plugins.odf.pilotage.controller.RemoveODFPilotageContentFromCurrentSelectionButtonController', {
    extend: "Ametys.plugins.contentstree.RemoveFromCurrentSelectionButtonController",
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * @private
     * Listener handler for modified messages
     * @param {Ametys.message.Message} message the message
     */
    _onModified: function(message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
    _getParentStatus: function(content, target)
    {
        this.callParent(arguments);
        
        if (!this.isDisabled())
        {
            var modelPath = target.getParameters().parentMetadataPath;
            
        	// Check the pilotage status of the parent because it's the parent which will be modified
            Ametys.plugins.odf.pilotage.helper.ODFPilotageControllerHelper.getRestrictionStatusFromId(this, content.getId(), modelPath);
        }
    }
    
});
