<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:template name="css-styles-mcc">
        table
        {
            width: 100%;
            padding: 0px;
            margin: 0px;
            border-spacing: 0;
            border-collapse: collapse;
            font-size: 7.5pt;
        }
        
        td
        {
            padding: 2pt;
            vertical-align: middle;
        }
        
        /** Header */
        
        table tr.new-header td
        {
            border-top: 1pt dashed lightgrey;
            font-size: 10pt;
        }
        
        table thead tr td.maquette
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #EEEEFF;
            border: 0.5pt #000080 solid;
            color: #000080;
        }
        
        table thead tr td.evaluation
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #000080;
            border: 0.5pt white solid;
            color: white;
        }
        
        table thead tr td.session1
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0000A0;
            border: 0.5pt white solid;
            color: white;
        }
        
        table thead tr td.session2
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0020C2;
            border: 0.5pt white solid;
            color: white;
        }
        
        table thead td.main-title1
        {
            background-color: white;
            color: #000080;
            font-size: 20pt;
        }
        
        table thead td.main-title2
        {
            background-color: white;
            color: #000080;
            font-size: 18pt;
        }
        
        table thead td.main-title3
        {
            background-color: white;
            color: #000080;
            font-size: 16pt;
        }
        
        table tbody tr.courselist td
        {
            font-style: italic;
            padding: 3px 1px;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr.elp td
        {
            padding: 3px 1px;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr.ue td
        {
            padding: 3px 1px;
            font-weight: bold;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr.first-ue td
        {
            padding: 3px 1px;
            font-weight: bold;
            border-top: 1pt black solid;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr td.nature-ens
        {
            border-right: 0.5pt white solid;
        }
        
        table.main tbody tr td.first-cell
        {
            text-align: center;
            border-left: 0.5pt #cccccc solid;
        }
        
        table tbody tr td.session-cell
        {
            border-right: 0.5pt white solid;
        }
        
        table tbody tr td.session-cell-centered
        {
            border-right: 0.5pt white solid;
            text-align: center;
        }
        
        table tbody tr td.session-cell-coef
        {
            mso-number-format:'\@';
            border-right: 0.5pt white solid;
            text-align: center;
        }
        
        table.main tbody tr td.centered
        {
            text-align: center;
        }
        
        tr.skills-title td
        {
            color: #000080;
            font-weight: bold;
            font-size: 8.0pt;
            border-top: 1pt #000080 solid;
            border-bottom: 1pt #000080 solid;
        }
        
        tr.programpart td
        {
            font-weight: bold;
            color: #000080;
        }
        
        td.enabled
        {
            background-color: #F0F8FF;
        }
        
        <!-- Légende -->
        .legend-title
        {
            color: #000080;
            font-weight: bold;
            padding-bottom: 3.0pt;
            font-size: 8.0pt;
        }
        
        .legend td
        {
            border-bottom: none;
            font-size: 8.0pt;
        }
        
        .legend td.enabled
        {
            padding-left: 3mm;
        }
        
        <!-- Autres styles -->
        .codeAmetys 
        { 
            color: #777777;
        }
        
        span.lang
        {
            font-weight: normal;
        }
        
        span.remarques
        {
            font-weight: normal;
            color: #777777;
        }
    </xsl:template>
</xsl:stylesheet>
