/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.content.compare.ContentComparator;
import org.ametys.cms.content.compare.ContentComparatorResult;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.plugins.odfpilotage.report.impl.AbstractMCCReport;
import org.ametys.plugins.odfpilotage.report.impl.tree.ProgramItemTree;
import org.ametys.plugins.odfpilotage.schedulable.AbstractReportSchedulable;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections4.SetUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MCCDiffReport
extends AbstractMCCReport {
    public static final String PARAMETER_CATALOG_OLD = "catalogOld";
    private static final String __OLD_FOR_NEW_PROGRAM_ITEMS_CACHE_ID = MCCDiffReport.class.getName() + "$old4newProgramItems";
    private ContentComparator _contentComparator;
    private AbstractCacheManager _cacheManager;

    @Override
    public String getType(Map<String, String> reportParameters, boolean shortName) {
        return "mccdiff";
    }

    @Override
    protected boolean isGeneric() {
        return false;
    }

    @Override
    protected boolean isCompatibleSchedulable(AbstractReportSchedulable schedulable) {
        return schedulable.getId().equals("org.ametys.plugins.odfpilotage.schedulable.OrgUnitMCCDiffReportSchedulable");
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentComparator = (ContentComparator)manager.lookup(ContentComparator.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this._cacheManager.createRequestCache(__OLD_FOR_NEW_PROGRAM_ITEMS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_OLD_FOR_NEW_PROGRAM_ITEMS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_OLD_FOR_NEW_PROGRAM_ITEMS_DESCRIPTION"), true);
    }

    @Override
    protected ProgramItemTree createMCCTreeFromProgramItem(ProgramItem programItem, Map<String, String> reportParameters) {
        ProgramItem oldProgramItem = this._findOldProgramItem(programItem, reportParameters.get(PARAMETER_CATALOG_OLD));
        ContentComparatorResult changes = this._getObjectChanges(oldProgramItem, programItem);
        ProgramItemTree programItemTree = new ProgramItemTree(programItem, changes);
        this.populateMCCTree(programItemTree);
        return programItemTree;
    }

    @Override
    protected void populateMCCTree(ProgramItemTree tree) {
        ProgramItem oldProgramItem = (ProgramItem)tree.getChange().getContent1();
        ProgramItem newProgramItem = (ProgramItem)tree.getChange().getContent2();
        if (oldProgramItem == null) {
            List children = this._odfHelper.getChildProgramItems(newProgramItem);
            for (ProgramItem child : children) {
                ContentComparatorResult changes = this._getObjectChanges(null, child);
                ProgramItemTree childTree = tree.addChild(child, changes);
                this.populateMCCTree(childTree);
            }
        } else if (newProgramItem == null) {
            List children = this._odfHelper.getChildProgramItems(oldProgramItem);
            for (ProgramItem child : children) {
                ContentComparatorResult changes = this._getObjectChanges(child, null);
                ProgramItemTree childTree = tree.addChild(child, changes);
                this.populateMCCTree(childTree);
            }
        } else {
            List oldChildren = this._odfHelper.getChildProgramItems(oldProgramItem);
            List newChildren = this._odfHelper.getChildProgramItems(newProgramItem);
            for (ProgramItem newChild : newChildren) {
                ProgramItem currentOldChild = null;
                Class newChildClass = newChild.getClass();
                String newChildCode = newChild.getCode();
                for (ProgramItem oldChild : oldChildren) {
                    if (!oldChild.getCode().equals(newChildCode) || !oldChild.getClass().equals(newChildClass)) continue;
                    currentOldChild = oldChild;
                    oldChildren.remove(oldChild);
                    break;
                }
                ContentComparatorResult changes = this._getObjectChanges(currentOldChild, newChild);
                ProgramItemTree childTree = tree.addChild(newChild, changes);
                this.populateMCCTree(childTree);
            }
            for (ProgramItem oldChild : oldChildren) {
                ContentComparatorResult changes = this._getObjectChanges(oldChild, null);
                ProgramItemTree childTree = tree.addChild(oldChild, changes);
                this.populateMCCTree(childTree);
            }
        }
    }

    private ContentComparatorResult _getObjectChanges(ProgramItem oldProgramItem, ProgramItem newProgramItem) {
        return new ContentComparatorResult((ModelAwareDataHolder)((Content)oldProgramItem), (ModelAwareDataHolder)((Content)newProgramItem));
    }

    private <T extends ProgramItem> T _findOldProgramItem(T content, String oldCatalog) {
        Cache cache = this._cacheManager.get(__OLD_FOR_NEW_PROGRAM_ITEMS_CACHE_ID);
        return (T)((ProgramItem)cache.get((Object)content.getId(), __ -> this._odfHelper.getProgramItem(content, oldCatalog, content.getLanguage())));
    }

    @Override
    protected boolean isExcludedFromMCC(ProgramItemTree tree) {
        Course oldCourse = (Course)tree.getChange().getContent1();
        Course newCourse = (Course)tree.getChange().getContent2();
        return !(oldCourse != null && !this._pilotageHelper.isExcludedFromMCC(oldCourse) || newCourse != null && !this._pilotageHelper.isExcludedFromMCC(newCourse));
    }

    @Override
    protected void saxSession(ContentHandler handler, ProgramItemTree tree, String sessionName) throws SAXException {
        boolean newContentSessionEnabled;
        ContentComparatorResult changes = tree.getChange();
        Content oldContent = changes.getContent1();
        Content newContent = changes.getContent2();
        ModelItem sessionDefinition = this._sessionsView.getModelViewItem(sessionName).getDefinition();
        boolean oldContentSessionEnabled = oldContent != null && !this._disableConditionsEvaluator.evaluateDisableConditions(sessionDefinition, sessionName, (Object)oldContent);
        boolean bl = newContentSessionEnabled = newContent != null && !this._disableConditionsEvaluator.evaluateDisableConditions(sessionDefinition, sessionName, (Object)newContent);
        if (oldContentSessionEnabled || newContentSessionEnabled) {
            XMLUtils.startElement((ContentHandler)handler, (String)sessionName);
            String oldCatalog = Optional.ofNullable(oldContent).map(ProgramItem.class::cast).map(ProgramItem::getCatalog).orElse(null);
            List newPath = tree.getPath().getProgramItems(this._resolver);
            List<ProgramItem> oldPath = this._buildOldPath(newPath, oldCatalog);
            Map oldEntriesByNature = oldContentSessionEnabled ? this._getEntriesByNature(oldContent, sessionName, oldPath) : Map.of();
            Map newEntriesByNature = newContentSessionEnabled ? this._getEntriesByNature(newContent, sessionName, newPath) : Map.of();
            SetUtils.SetView natures = SetUtils.union(oldEntriesByNature.keySet(), newEntriesByNature.keySet());
            for (String nature : natures) {
                List oldEntries = oldEntriesByNature.getOrDefault(nature, List.of());
                List newEntries = newEntriesByNature.getOrDefault(nature, List.of());
                int oldEntriesSize = oldEntries.size();
                int newEntriesSize = newEntries.size();
                int maxSize = Integer.max(oldEntriesSize, newEntriesSize);
                for (int i = 0; i < maxSize; ++i) {
                    ModelAwareRepeaterEntry newEntry;
                    if (i >= oldEntriesSize) {
                        this._saxSessionEntry(handler, (ModelAwareRepeaterEntry)newEntries.get(i), newContent, ProgramItemTree.ChangeType.ADDED);
                        continue;
                    }
                    if (i >= newEntriesSize) {
                        this._saxSessionEntry(handler, (ModelAwareRepeaterEntry)oldEntries.get(i), oldContent, ProgramItemTree.ChangeType.REMOVED);
                        continue;
                    }
                    ModelAwareRepeaterEntry oldEntry = (ModelAwareRepeaterEntry)oldEntries.get(i);
                    ContentComparatorResult result = this._contentComparator.compare((ModelAwareDataHolder)oldEntry, (ModelAwareDataHolder)(newEntry = (ModelAwareRepeaterEntry)newEntries.get(i)), (ViewItemAccessor)ViewHelper.getModelViewItem((ViewItemAccessor)this._sessionsView, (String)sessionName));
                    if (result.areEquals()) {
                        this._saxSessionEntry(handler, newEntry, newContent, null);
                        continue;
                    }
                    this._saxSessionEntry(handler, oldEntry, oldContent, ProgramItemTree.ChangeType.MODIFIED_OLD);
                    this._saxSessionEntry(handler, newEntry, newContent, ProgramItemTree.ChangeType.MODIFIED_NEW);
                }
            }
            XMLUtils.endElement((ContentHandler)handler, (String)sessionName);
        }
    }

    private void _saxSessionEntry(ContentHandler handler, ModelAwareRepeaterEntry sessionEntry, Content rootContent, ProgramItemTree.ChangeType changeType) throws SAXException {
        AttributesImpl entryAttrs = new AttributesImpl();
        entryAttrs.addCDATAAttribute("name", String.valueOf(sessionEntry.getPosition()));
        if (changeType != null) {
            entryAttrs.addCDATAAttribute("changeType", changeType.name().toLowerCase());
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"entry", (Attributes)entryAttrs);
        this.saxSessionEntryDetails(handler, sessionEntry, rootContent);
        XMLUtils.endElement((ContentHandler)handler, (String)"entry");
    }

    private List<ProgramItem> _buildOldPath(List<ProgramItem> newPath, String oldCatalog) {
        if (oldCatalog == null) {
            return List.of();
        }
        ArrayList<ProgramItem> oldPath = new ArrayList<ProgramItem>();
        for (ProgramItem newProgramItem : newPath) {
            ProgramItem oldProgramItem = this._findOldProgramItem(newProgramItem, oldCatalog);
            if (oldProgramItem == null || oldProgramItem.equals((Object)newProgramItem)) {
                return List.of();
            }
            oldPath.add(oldProgramItem);
        }
        return oldPath;
    }

    private Map<String, List<ModelAwareRepeaterEntry>> _getEntriesByNature(Content content, String sessionName, List<ProgramItem> educationalPath) {
        return Optional.ofNullable(content).map(c -> c.getRepeater(sessionName)).map(r -> {
            List educationalPaths = educationalPath.isEmpty() ? List.of() : this._odfHelper.getEducationPathFromPath(educationalPath);
            return this._odfHelper.getRepeaterEntriesByPath((ModelAwareRepeater)r, educationalPaths);
        }).orElseGet(() -> Stream.of(new ModelAwareRepeaterEntry[0])).collect(Collectors.groupingBy(this::_getNatureEnseignementId));
    }

    private String _getNatureEnseignementId(ModelAwareRepeaterEntry entry) {
        return Optional.of(entry).map(e -> (ContentValue)e.getValue("natureEnseignement")).map(ContentValue::getContentId).orElse("");
    }

    @Override
    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        super.saxGlobalInformations(handler, programItem, reportParameters);
        String oldCatalog = reportParameters.get(PARAMETER_CATALOG_OLD);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", oldCatalog);
        XMLUtils.createElement((ContentHandler)handler, (String)PARAMETER_CATALOG_OLD, (Attributes)attrs, (String)this._catalogsManager.getCatalog(oldCatalog).getTitle());
    }
}

