/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.validator;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.data.holder.group.IndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.rights.ODFRightHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.repository.data.holder.values.UntouchedValue;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class CourseMccSkillsValidator
extends AbstractContentValidator
implements Serviceable,
Initializable,
Contextualizable {
    private static final String __MCC_SESSION1 = "mccSession1";
    private static final String __MCC_SESSION2 = "mccSession2";
    private static final String __MCC_SESSION_COMMON = "common";
    private static final String __MCC_SESSION_PATH = "path";
    private static final String __MCC_SESSION_NOTES = "notes";
    private static final String __MCC_SESSION_NOTES_SKILLS = "skills";
    private static final String __MCC_SESSION_NOTES_SKILLS_SKILL = "skill";
    private static final String __MCC_SESSION_NOTES_SKILLS_PATH = "path";
    private DisableConditionsEvaluator _disableConditionsEvaluator;
    private ODFHelper _odfHelper;
    private RightManager _rightManager;
    private CurrentUserProvider _currentUserProvider;
    private boolean _isSkillsEnabled;
    private Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void initialize() throws ConfigurationException {
        super.initialize();
        this._isSkillsEnabled = (Boolean)Config.getInstance().getValue("odf.skills.enabled");
    }

    public ValidationResult validate(Content content) {
        ValidationResult result = new ValidationResult();
        if (this._isSkillsEnabled && content instanceof Course) {
            Course course = (Course)content;
            Optional<EducationalPath> courseEducationalPath = this._getUniqueEducationalPath(course);
            result.addResult(this._checkSession(course, __MCC_SESSION1, courseEducationalPath));
            result.addResult(this._checkSession(course, __MCC_SESSION2, courseEducationalPath));
        }
        return result;
    }

    private ValidationResult _checkSession(Course course, String mccSession, Optional<EducationalPath> courseEducationalPath) {
        ValidationResult result = new ValidationResult();
        RepeaterDefinition mccSessionDefinition = (RepeaterDefinition)course.getDefinition(mccSession);
        if (!this._disableConditionsEvaluator.evaluateDisableConditions((ModelItem)mccSessionDefinition, mccSession, (Object)course)) {
            RepeaterDefinition noteDefinition = (RepeaterDefinition)mccSessionDefinition.getModelItem(__MCC_SESSION_NOTES);
            HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
            i18nParams.put("sessionRepeater", mccSessionDefinition.getLabel());
            i18nParams.put("noteRepeater", noteDefinition.getLabel());
            i18nParams.put("skillRepeater", noteDefinition.getModelItem(__MCC_SESSION_NOTES_SKILLS).getLabel());
            Optional.ofNullable(course.getRepeater(mccSession)).map(IndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new IndexableRepeaterEntry[0])).map(entry -> this._checkSessionEntry(course, (IndexableRepeaterEntry)entry, courseEducationalPath, (Map<String, I18nizableTextParameter>)i18nParams)).forEach(arg_0 -> ((ValidationResult)result).addResult(arg_0));
        }
        return result;
    }

    private ValidationResult _checkSessionEntry(Course course, IndexableRepeaterEntry sessionEntry, Optional<EducationalPath> courseEducationalPath, Map<String, I18nizableTextParameter> commonI18nParams) {
        ValidationResult result = new ValidationResult();
        HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
        i18nParams.put("sessionPosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(sessionEntry.getPosition())));
        Optional<EducationalPath> sessionEntryEducationalPath = courseEducationalPath.or(() -> Optional.of(sessionEntry).filter(entry -> (Boolean)entry.getValue(__MCC_SESSION_COMMON, true, (Object)true) == false).map(entry -> (EducationalPath)entry.getValue("path")));
        Optional.ofNullable(sessionEntry.getRepeater(__MCC_SESSION_NOTES)).map(IndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new IndexableRepeaterEntry[0])).map(noteEntry -> this._checkNoteEntry(course, (IndexableRepeaterEntry)noteEntry, sessionEntryEducationalPath, (Map<String, I18nizableTextParameter>)i18nParams)).forEach(arg_0 -> ((ValidationResult)result).addResult(arg_0));
        return result;
    }

    private ValidationResult _checkNoteEntry(Course course, IndexableRepeaterEntry noteEntry, Optional<EducationalPath> sessionEntryEducationalPath, Map<String, I18nizableTextParameter> commonI18nParams) {
        ValidationResult result = new ValidationResult();
        HashMap<EducationalPath, Set> skillsByPath = new HashMap<EducationalPath, Set>();
        List skillEntries = Optional.ofNullable(noteEntry.getRepeater(__MCC_SESSION_NOTES_SKILLS)).map(IndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new IndexableRepeaterEntry[0])).toList();
        for (IndexableRepeaterEntry skillEntry : skillEntries) {
            String programId;
            ContentValue[] acquiredSkills;
            ContentValue skill = (ContentValue)skillEntry.getValue(__MCC_SESSION_NOTES_SKILLS_SKILL);
            EducationalPath educationalPath = sessionEntryEducationalPath.orElseGet(() -> (EducationalPath)skillEntry.getValue("path"));
            if (skill == null || educationalPath == null) continue;
            HashMap<String, I18nizableTextParameter> noteI18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
            noteI18nParams.put("notePosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(noteEntry.getPosition())));
            Set skillsForPath = skillsByPath.computeIfAbsent(educationalPath, __ -> new HashSet());
            if (!skillsForPath.add(skill)) {
                result.addError(this._buildDuplicationMessage(noteI18nParams, skill, educationalPath));
                continue;
            }
            if (educationalPath.getProgramItemIds().size() <= 0 || Arrays.asList(acquiredSkills = course.getAcquiredSkills(programId = (String)educationalPath.getProgramItemIds().get(0))).contains(skill)) continue;
            result.addError(this._buildInconsistentMessage(noteI18nParams, skillEntry.getPosition(), skill, course));
        }
        return result;
    }

    public ValidationResult validate(Content content, Map<String, Object> values, View view) {
        ValidationResult result = new ValidationResult();
        if (this._isSkillsEnabled && content instanceof Course) {
            Course course = (Course)content;
            Optional<EducationalPath> courseEducationalPath = this._getUniqueEducationalPath(course);
            List<EducationalPath> currentEducationPaths = this._getCurrentEducationPaths(course);
            result.addResult(this._checkSession(course, values, __MCC_SESSION1, courseEducationalPath, currentEducationPaths));
            result.addResult(this._checkSession(course, values, __MCC_SESSION2, courseEducationalPath, currentEducationPaths));
        }
        return result;
    }

    private ValidationResult _checkSession(Course course, Map<String, Object> values, String mccSession, Optional<EducationalPath> courseEducationalPath, List<EducationalPath> currentEducationPaths) {
        ValidationResult result = new ValidationResult();
        List<Map<String, Object>> mccSessionEntries = this._getRepeaterEntries(values, mccSession);
        if (!mccSessionEntries.isEmpty()) {
            RepeaterDefinition mccSessionDefinition = (RepeaterDefinition)course.getDefinition(mccSession);
            RepeaterDefinition noteDefinition = (RepeaterDefinition)mccSessionDefinition.getModelItem(__MCC_SESSION_NOTES);
            HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>();
            i18nParams.put("sessionRepeater", (I18nizableTextParameter)mccSessionDefinition.getLabel());
            i18nParams.put("noteRepeater", (I18nizableTextParameter)noteDefinition.getLabel());
            i18nParams.put("skillRepeater", (I18nizableTextParameter)noteDefinition.getModelItem(__MCC_SESSION_NOTES_SKILLS).getLabel());
            int entryPosition = 1;
            for (Map<String, Object> sessionEntry : mccSessionEntries) {
                String prefix = mccSession + "[" + entryPosition + "]";
                result.addResult(this._checkSessionEntry(course, prefix, sessionEntry, entryPosition, courseEducationalPath, currentEducationPaths, i18nParams));
                ++entryPosition;
            }
        }
        return result;
    }

    private ValidationResult _checkSessionEntry(Course course, String prefixPath, Map<String, Object> sessionEntry, int sessionEntryPosition, Optional<EducationalPath> courseEducationalPath, List<EducationalPath> currentEducationPaths, Map<String, I18nizableTextParameter> commonI18nParams) {
        ValidationResult result = new ValidationResult();
        List<Map<String, Object>> noteEntries = this._getRepeaterEntries(sessionEntry, __MCC_SESSION_NOTES);
        if (!noteEntries.isEmpty()) {
            HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
            i18nParams.put("sessionPosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(sessionEntryPosition)));
            Optional<EducationalPath> sessionEntryEducationalPath = courseEducationalPath.or(() -> Optional.of(sessionEntry).filter(entry -> Objects.requireNonNullElse((Boolean)this._getValue(course, (Map<String, Object>)entry, prefixPath, __MCC_SESSION_COMMON), true) == false).map(entry -> this._getValue(course, (Map<String, Object>)entry, prefixPath, "path")).map(EducationalPath.class::cast));
            int entryPosition = 1;
            for (Map<String, Object> noteEntry : noteEntries) {
                String prefix = prefixPath + "/notes[" + entryPosition + "]";
                result.addResult(this._checkNoteEntry(course, prefix, noteEntry, entryPosition, sessionEntryEducationalPath, currentEducationPaths, i18nParams));
                ++entryPosition;
            }
        }
        return result;
    }

    private ValidationResult _checkNoteEntry(Course course, String prefixPath, Map<String, Object> noteEntry, int noteEntryPosition, Optional<EducationalPath> sessionEntryEducationalPath, List<EducationalPath> currentEducationPaths, Map<String, I18nizableTextParameter> commonI18nParams) {
        ValidationResult result = new ValidationResult();
        List<Map<String, Object>> skillEntries = this._getRepeaterEntries(noteEntry, __MCC_SESSION_NOTES_SKILLS);
        if (!skillEntries.isEmpty()) {
            HashMap<EducationalPath, Set> skillsByPath = new HashMap<EducationalPath, Set>();
            int entryPosition = 1;
            for (Map<String, Object> skillEntry : skillEntries) {
                String prefix = prefixPath + "/skills[" + entryPosition + "]";
                ContentValue skill = (ContentValue)this._getValue(course, skillEntry, prefix, __MCC_SESSION_NOTES_SKILLS_SKILL);
                EducationalPath educationalPath = sessionEntryEducationalPath.orElseGet(() -> (EducationalPath)this._getValue(course, skillEntry, prefix, "path"));
                if (skill != null && educationalPath != null && (currentEducationPaths.isEmpty() || currentEducationPaths.contains(educationalPath))) {
                    String programId;
                    ContentValue[] acquiredSkills;
                    HashMap<String, I18nizableTextParameter> noteI18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
                    noteI18nParams.put("notePosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(noteEntryPosition)));
                    Set skillsForPath = skillsByPath.computeIfAbsent(educationalPath, __ -> new HashSet());
                    if (!skillsForPath.add(skill)) {
                        result.addWarning(this._buildDuplicationMessage(noteI18nParams, skill, educationalPath));
                    } else if (educationalPath.getProgramItemIds().size() > 0 && !Arrays.asList(acquiredSkills = course.getAcquiredSkills(programId = (String)educationalPath.getProgramItemIds().get(0))).contains(skill)) {
                        result.addWarning(this._buildInconsistentMessage(noteI18nParams, entryPosition, skill, course));
                    }
                }
                ++entryPosition;
            }
        }
        return result;
    }

    private List<EducationalPath> _getCurrentEducationPaths(Course course) {
        Request request = ContextHelper.getRequest((Context)this._context);
        UserIdentity user = this._currentUserProvider.getUser();
        boolean hasRightToEdit = this._rightManager.hasRight(user, "ODF_Rights_Course_Edit", (Object)course) == RightManager.RightResult.RIGHT_ALLOW;
        List educationalPaths = (List)request.getAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS);
        return educationalPaths == null ? List.of() : educationalPaths.stream().filter(path -> hasRightToEdit || this._hasRightToEditOnPath(course, (EducationalPath)path, user)).toList();
    }

    private boolean _hasRightToEditOnPath(Course course, EducationalPath path, UserIdentity user) {
        return this._rightManager.hasRight(user, "ODF_Rights_Course_Edit", (Object)new ODFRightHelper.ContextualizedContent((Content)course, path)) == RightManager.RightResult.RIGHT_ALLOW;
    }

    private Optional<EducationalPath> _getUniqueEducationalPath(Course course) {
        List educationalPaths = this._odfHelper.getEducationalPaths((ProgramItem)course, true, true);
        return educationalPaths.size() == 1 ? Optional.of((EducationalPath)educationalPaths.get(0)) : Optional.empty();
    }

    private List<Map<String, Object>> _getRepeaterEntries(Map<String, Object> syncValues, String attributeName) {
        Object value = syncValues.get(attributeName);
        return value == null || value instanceof UntouchedValue ? List.of() : (value instanceof List ? (List)value : ((SynchronizableRepeater)value).getEntries());
    }

    private Object _getValue(Course course, Map<String, Object> syncValues, String prefixPath, String attributeName) {
        Object value;
        Object object = value = syncValues.get(attributeName);
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UntouchedValue.class, SynchronizableValue.class}, (Object)object2, n)) {
            case 0: {
                UntouchedValue untouchedValue = (UntouchedValue)object2;
                return course.getValue(prefixPath + "/" + attributeName);
            }
            case 1: {
                SynchronizableValue syncValue = (SynchronizableValue)object2;
                return syncValue.getValue(Optional.ofNullable(syncValue.getExternalizableStatus()));
            }
        }
        return value;
    }

    private I18nizableText _buildDuplicationMessage(Map<String, I18nizableTextParameter> commonI18nParams, ContentValue skill, EducationalPath educationalPath) {
        HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
        i18nParams.put(__MCC_SESSION_NOTES_SKILLS_SKILL, (I18nizableTextParameter)new I18nizableText(skill.getContentIfExists().map(Content::getTitle).orElseGet(() -> skill.getContentId())));
        i18nParams.put("educationalPath", (I18nizableTextParameter)new I18nizableText(this._odfHelper.getEducationalPathAsString(educationalPath)));
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCCSKILLS_VALIDATOR_ERROR_DUPLICATED", i18nParams);
    }

    private I18nizableText _buildInconsistentMessage(Map<String, I18nizableTextParameter> commonI18nParams, int skillPosition, ContentValue skill, Course course) {
        HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
        i18nParams.put("skillPosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(skillPosition)));
        i18nParams.put(__MCC_SESSION_NOTES_SKILLS_SKILL, (I18nizableTextParameter)new I18nizableText(skill.getContentIfExists().map(Content::getTitle).orElseGet(() -> skill.getContentId())));
        i18nParams.put("course", (I18nizableTextParameter)new I18nizableText(course.getTitle()));
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCCSKILLS_VALIDATOR_ERROR_INCONSISTENT", i18nParams);
    }
}

