<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                              xmlns:double="java.lang.Double"
                              xmlns:stringutils="org.apache.commons.lang.StringUtils"
                              exclude-result-prefixes="exsl cms docbook odf double stringutils">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/params/mcc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/doc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc/legende2doc.xsl"/>
    
    <xsl:param name="mainOrientation" select="'landscape'"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-mcc"/>
    </xsl:template>
    
    <xsl:template name="css-styles-mcc">
        #main-<xsl:value-of select="$uniqueSectionId"/> h1,
        #skills-<xsl:value-of select="$uniqueSectionId"/> h1,
        #legend-<xsl:value-of select="$uniqueSectionId"/> h1
        {
            margin-top:0;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> body,
        #skills-<xsl:value-of select="$uniqueSectionId"/> body,
        #legend-<xsl:value-of select="$uniqueSectionId"/> body
        {
            font-size: 6pt;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main,
        #main-<xsl:value-of select="$uniqueSectionId"/> table.size-8,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.size-8,
        #legend-<xsl:value-of select="$uniqueSectionId"/> table.legend
        {
            width: 100%;
            padding: 0px;
            margin: 0px;
            border-spacing: 0;
            border-collapse: collapse;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main td,
        #main-<xsl:value-of select="$uniqueSectionId"/> table.size-8 td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.size-8 td,
        #legend-<xsl:value-of select="$uniqueSectionId"/> table.legend td
        {
            padding: 2pt;
        }
        
        /** Header */
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table tr.new-header td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table tr.new-header td
        {
            border-top: 1pt dashed lightgrey;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.maquette,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.maquette
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #EEEEFF;
            border: 0.5pt #000080 solid;
            color: #000080;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.evaluation,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.evaluation
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #000080;
            border: 0.5pt white solid;
            color: white;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.session1,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.session1
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0000A0;
            border: 0.5pt white solid;
            color: white;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.session2,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table thead tr td.session2
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0020C2;
            border: 0.5pt white solid;
            color: white;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr.courselist td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr.courselist td
        {
            font-style: italic;
            padding: 3px 1px;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr.elp td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr.elp td
        {
            padding: 3px 1px;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr.ue td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr.ue td
        {
            padding: 3px 1px;
            font-weight: bold;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr.first-ue td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr.first-ue td
        {
            padding: 3px 1px;
            font-weight: bold;
            border-top: 1pt black solid;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.nature-ens,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr td.nature-ens
        {
            border-right: 0.5pt white solid;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.first-cell,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr td.first-cell
        {
            text-align: center;
            border-left: 0.5pt #cccccc solid;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr td.session-cell
        {
            border-right: 0.5pt white solid;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-centered,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr td.session-cell-centered
        {
            border-right: 0.5pt white solid;
            text-align: center;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.centered,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr td.centered
        {
            text-align: center;
        }
        
        #skills-<xsl:value-of select="$uniqueSectionId"/> td.enabled,
        #legend-<xsl:value-of select="$uniqueSectionId"/> td.enabled
        {
            background-color: #F0F8FF;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr td
        {
            page-break-inside: avoid;
        }
        
        <!-- Légende -->
        #legend-<xsl:value-of select="$uniqueSectionId"/> .legend-title,
        #skills-<xsl:value-of select="$uniqueSectionId"/> .skills-title
        {
            color: #000080;
            font-weight: bold;
            padding-bottom: 3.0pt;
            font-size: 8.0pt;
        }
        
        #legend-<xsl:value-of select="$uniqueSectionId"/> table.legend td
        {
            vertical-align: middle;
        }
        
        <!-- Autres styles -->
        #main-<xsl:value-of select="$uniqueSectionId"/> .codeAmetys,
        #skills-<xsl:value-of select="$uniqueSectionId"/> .codeAmetys,
        #legend-<xsl:value-of select="$uniqueSectionId"/> .codeAmetys
        {
            color: #777777;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> .size-8,
        #skills-<xsl:value-of select="$uniqueSectionId"/> .size-8,
        #legend-<xsl:value-of select="$uniqueSectionId"/> .size-8
        {
            font-size: 8.0pt;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> div.lang
        {
            font-weight: normal;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> div.remarques
        {
            font-weight: normal;
            color: #777777;
        }
        
        #main-<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr.programpart td,
        #skills-<xsl:value-of select="$uniqueSectionId"/> table.skills tbody tr.programpart td
        {
            font-weight: bold;
            color: #000080;
        }
    </xsl:template>
    
    <xsl:template name="doc-title">
        <xsl:value-of select="/report/title" />
    </xsl:template>
    
    <xsl:template name="footer">
        <xsl:value-of select="title" />
        <xsl:text> - </xsl:text>
        <xsl:apply-templates select="program|subProgram|container" mode="catalog"/>
    </xsl:template>
    
    <xsl:template name="doc-body">
        <div class="{$mainOrientation}-a4" id="main-{$uniqueSectionId}">
            <xsl:call-template name="body"/>
        </div>
        
        <!-- Detailled skills table -->
        <xsl:if test="$hasPonderationInSkills">
            <xsl:call-template name="new-section" />
            <xsl:call-template name="skills-section" />
        </xsl:if>
        
        <!-- Legend -->
        <xsl:call-template name="new-section" />
        <div class="{$mainOrientation}-a4" id="legend-{$uniqueSectionId}">
            <xsl:call-template name="legende" />
        </div>
    </xsl:template>
    
    <xsl:template name="skills-section">
        <!-- A3 landscape format -->
        <div class="landscape-a3" id="skills-{$uniqueSectionId}">
            <p class="skills-title">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_SKILLS"/>
                <xsl:text> - </xsl:text>
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_1"/>
            </p>
            <xsl:call-template name="skills-table">
                <xsl:with-param name="isFirstSession" select="true()"/>
            </xsl:call-template>
            
            <xsl:if test="//course[@session2 = 'available']">
                <xsl:call-template name="new-page"/>
                <p class="skills-title">
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_SKILLS"/>
                    <xsl:text> - </xsl:text>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_2"/>
                </p>
                <xsl:call-template name="skills-table">
                    <xsl:with-param name="isFirstSession" select="false()"/>
                </xsl:call-template>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="skills-table">
        <xsl:param name="isFirstSession"/>
        
        <table class="skills">
            <thead>
                <xsl:call-template name="skills-table-header"/>
            </thead>
            <tbody>
                <xsl:apply-templates select="program|subProgram|container" mode="skills">
                    <xsl:with-param name="isFirstSession" select="$isFirstSession"/>
                </xsl:apply-templates>
            </tbody>
        </table>
    </xsl:template>
    
    <xsl:template name="skills-table-header">
        <!-- First row to group titles -->
        <tr>
            <td class="maquette" colspan="{$nbSkillsColumnsCommon}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MAQUETTE"/>
            </td>
            <td class="evaluation" colspan="{$nbSkillsColumns}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SKILLS"/>
            </td>
        </tr>
        
        <!-- Second row with general attributes and macro skills -->
        <tr>
            <td style="width: 5cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_LABEL"/>
            </td>
            <td style="width: 5mm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_COEF"/>
            </td>
            <td style="width: 2cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/>
            </td>
            <td style="width: 5mm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NB_NOTES"/>
            </td>
            <td style="width: 2cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_PONDERATION"/>
            </td>
            <xsl:for-each select="/report/skills/macro">
                <td class="session1" colspan="{count(micro)}">
                    <xsl:if test="code != ''">
                        <xsl:value-of select="code"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="title"/>
                </td>
            </xsl:for-each>
        </tr>
        
        <!-- Third row with micro skills -->
        <tr>
            <xsl:for-each select="/report/skills/macro/micro">
                <td class="session2">
                    <xsl:if test="code != ''">
                        <xsl:value-of select="code"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="title"/>
                </td>
            </xsl:for-each>
        </tr>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="skills">
        <xsl:param name="depth" select="0"/>
        <xsl:param name="isFirstSession"/>
        
        <xsl:if test="$isFirstSession or .//course[@session2 = 'available']">
            <!-- Display the program item title -->
            <tr class="programpart">
                <td colspan="{$nbAllSkillsColumns}">
                    <!-- Identation. Print 4 spaces per level -->
                    <xsl:call-template name="recursive-print">
                        <xsl:with-param name="times" select="$depth" />
                    </xsl:call-template>
                    <xsl:value-of select="title"/>
                </td>
            </tr>
            
            <!-- Explore children -->
            <xsl:apply-templates select="subProgram|container|courseList" mode="skills">
                <xsl:with-param name="depth" select="$depth + 1"/>
                <xsl:with-param name="isFirstSession" select="$isFirstSession"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="courseList" mode="skills">
        <xsl:param name="depth"/>
        <xsl:param name="isFirstSession"/>
        
        <xsl:if test="$isFirstSession or .//course[@session2 = 'available']">
            <!-- Display the course list type if it is not mandatory -->
            <xsl:variable name="courseListChoice" select="choiceType/@value"/>
            <xsl:choose>
                <xsl:when test="$courseListChoice = 'CHOICE'">
                    <tr class="courselist">
                        <td colspan="{$nbAllSkillsColumns}">
                            <xsl:call-template name="recursive-print">
                                <xsl:with-param name="times" select="$depth" />
                            </xsl:call-template>
                            <i18n:translate>
                                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_CHOICE"/>
                                <i18n:param><xsl:value-of select="min" /></i18n:param>
                            </i18n:translate>
                        </td>
                    </tr>
                </xsl:when>
                <xsl:when test="$courseListChoice = 'OPTIONAL'">
                    <tr class="courselist">
                        <td colspan="{$nbAllSkillsColumns}">
                            <xsl:call-template name="recursive-print">
                                <xsl:with-param name="times" select="$depth" />
                            </xsl:call-template>
                            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_OPTIONAL"/>
                        </td>
                    </tr>
                </xsl:when>
            </xsl:choose>
            
            <!-- Explore children -->
            <xsl:apply-templates select="course" mode="skills">
                <xsl:with-param name="depth" select="$depth + ($courseListChoice != 'MANDATORY')"/>
                <xsl:with-param name="isFirstSession" select="$isFirstSession"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="course" mode="skills">
        <xsl:param name="depth"/>
        <xsl:param name="isFirstSession"/>
        
        <xsl:if test="$isFirstSession or @session2 = 'available'">
            <xsl:variable name="sessionName">
                <xsl:choose>
                    <xsl:when test="$isFirstSession">mccSession1</xsl:when>
                    <xsl:otherwise>mccSession2</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="mccSessionEntries" select="mcc/*[local-name() = $sessionName]/entry"/>
            
            <xsl:variable name="currentCourseType" select="courseType/code"/>
            <xsl:variable name="nbNotes" select="cms:getTotalNotesRowspan($mccSessionEntries, foo, false())"/>
            
            <!-- Details of the course -->
            <tr>
                <xsl:call-template name="course-attributes">
                    <xsl:with-param name="type" select="$currentCourseType"/>
                    <xsl:with-param name="isFirst" select="false()"/>
                </xsl:call-template>
                <td rowspan="{$nbNotes}">
                    <!-- Identation. Print 4 spaces per level -->
                    <xsl:call-template name="recursive-print">
                        <xsl:with-param name="times" select="$depth" />
                    </xsl:call-template>
                    <xsl:value-of select="title"/>
                </td>
                <td rowspan="{$nbNotes}">
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="odf:getValueForPath(@id, 'mccCoefficientByEducationalPath/coefficient', @path, 'mccCoefficient')" />
                    </xsl:call-template>
                </td>
                
                <!-- Details of the first mccSession1 entry, if there is not, empty cells are displayed -->
                <xsl:choose>
                    <xsl:when test="$mccSessionEntries">
                        <xsl:apply-templates select="$mccSessionEntries[1]" mode="skills-session"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <td/>
                        <td/>
                        <td/>
                        <xsl:variable name="currentCourse" select="."/>
                        <xsl:for-each select="/report/skills/macro/micro">
                            <xsl:variable name="currentSkillId" select="@id"/>
                            <xsl:variable name="enableSkill" select="$currentCourse/acquiredMicroSkills/entry/microSkills[@id = $currentSkillId]"/>
                            <td>
                                <xsl:if test="$enableSkill">
                                    <xsl:attribute name="class">enabled</xsl:attribute>
                                </xsl:if>
                             </td>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </tr>
            
            <!-- Details of the other mccSession1 entries, except the first one (already displayed in the previous row) -->
            <!-- But for the first entry, we displayed the note except the first one too (already displayed in the previous row) -->
            <xsl:for-each select="$mccSessionEntries">
                <!-- Details of the mccSession1 entry -->
                <xsl:if test="position() != 1">
                    <tr>
                        <xsl:call-template name="course-attributes">
                            <xsl:with-param name="type" select="$currentCourseType"/>
                            <xsl:with-param name="isFirst" select="false()"/>
                        </xsl:call-template>
                        <xsl:apply-templates select="." mode="skills-session"/>
                    </tr>
                </xsl:if>
                
                <!-- Details of notes of the mccSession entry, except the first one (already displayed in the previous row) -->
                <xsl:for-each select="notes/entry[position() > 1]">
                    <tr>
                        <xsl:call-template name="course-attributes">
                            <xsl:with-param name="type" select="$currentCourseType"/>
                            <xsl:with-param name="isFirst" select="false()"/>
                        </xsl:call-template>
                        <xsl:apply-templates select="." mode="skills-session-notes"/>
                    </tr>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:if>
        
        <!-- Explore children -->
        <xsl:apply-templates select="courseList" mode="skills">
            <xsl:with-param name="depth" select="$depth + 1"/>
            <xsl:with-param name="isFirstSession" select="$isFirstSession"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="skills-session">
        <xsl:variable name="nbNotesSessionEntry" select="count(notes/entry)"/>
        <td rowspan="{$nbNotesSessionEntry}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="modalite/@id"/>
            </xsl:call-template>
            <xsl:if test="label != ''">
                <xsl:text> - </xsl:text>
                <xsl:value-of select="label"/>
            </xsl:if>
        </td>
        <td rowspan="{$nbNotesSessionEntry}">
            <xsl:choose>
                <xsl:when test="notes/entry">
                    <xsl:value-of select="$nbNotesSessionEntry"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="default-nb-notes"/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
        
        <xsl:choose>
            <xsl:when test="notes/entry">
                <xsl:apply-templates select="notes/entry[1]" mode="skills-session-notes"/>
            </xsl:when>
            <xsl:otherwise>
                <td/>
                <xsl:variable name="currentCourse" select="ancestor::course[1]"/>
                <xsl:for-each select="/report/skills/macro/micro">
                    <xsl:variable name="currentSkillId" select="@id"/>
                    <xsl:variable name="enableSkill" select="$currentCourse/acquiredMicroSkills/entry/microSkills[@id = $currentSkillId]"/>
                    <td>
                        <xsl:if test="$enableSkill">
                            <xsl:attribute name="class">enabled</xsl:attribute>
                        </xsl:if>
                     </td>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="entry" mode="skills-session-notes">
        <td>
            <xsl:choose>
                <xsl:when test="ponderation != ''">
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="ponderation"/>
                        <xsl:with-param name="showZero" select="true()" />
                        <xsl:with-param name="format" select="'#,##'"/>
                    </xsl:call-template>
                    <xsl:text>%</xsl:text>
                    <xsl:if test="label != ''">
                        <xsl:text> - </xsl:text>
                        <xsl:value-of select="label"/>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="default-ponderation"/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
        
        <xsl:variable name="currentNote" select="."/>
        <xsl:variable name="currentCourse" select="ancestor::course[1]"/>
        <xsl:for-each select="/report/skills/macro/micro">
            <xsl:variable name="currentSkillId" select="@id"/>
            <xsl:variable name="enableSkill" select="$currentCourse/acquiredMicroSkills/entry/microSkills[@id = $currentSkillId]"/>
            <td>
                <xsl:if test="$enableSkill">
                    <xsl:attribute name="class">enabled</xsl:attribute>
                    <xsl:variable name="matchingSkillEntry" select="$currentNote/skills/entry[skill/@id = $currentSkillId][not(path) or stringutils:endsWith(path, $currentCourse/@path)]"/>
                    <xsl:if test="$matchingSkillEntry">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="$matchingSkillEntry/ponderation"/>
                            <xsl:with-param name="showZero" select="true()" />
                            <xsl:with-param name="format" select="'#,##'"/>
                        </xsl:call-template>
                        <xsl:text>%</xsl:text>
                    </xsl:if>
                </xsl:if>
            </td>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="body">
        <xsl:apply-templates select="program|subProgram|container" mode="document-content" />
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="document-content">
        <xsl:apply-templates select="." mode="title"/>
        <xsl:apply-templates select="subProgram|container|courseList"/>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="title">
        <p id="first-page">
            <h1><xsl:value-of select="title"/></h1>
            <xsl:call-template name="catalog-title"/>
            <xsl:if test="/report/path">
                <h3><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_INCLUDES"/>
                    <ul>
                        <xsl:for-each select="/report/path">
                            <li><xsl:value-of select="."/></li>
                        </xsl:for-each>
                    </ul>
                </h3>
            </xsl:if>
            <table class="size-8" border-collapse="collapse">
                <colgroup>
                    <col width="50%"/>
                    <col width="50%"/>
                </colgroup>
                <xsl:apply-templates select="." mode="section-header-line"/>
                <tr class="new-header"><td colspan="2">&#160;</td></tr>
            </table>
        </p>
    </xsl:template>
    
    <xsl:template name="catalog-title">
        <h2><xsl:apply-templates select="." mode="catalog"/></h2>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="catalog">
        <xsl:value-of select="/report/catalog"/>
    </xsl:template>
    
    <xsl:template name="section-header">
        <table class="size-8" border-collapse="collapse">
            <colgroup>
                <col width="50%"/>
                <col width="50%"/>
            </colgroup>
            <xsl:apply-templates select="ancestor-or-self::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container']" mode="section-header-line"/>
            <tr class="new-header"><td colspan="2">&#160;</td></tr>
        </table>
    </xsl:template>
    
    <xsl:template match="program" mode="section-header-line">
        <tr class="new-header">
            <td>
                <strong><xsl:value-of select="title"/></strong>
                <xsl:apply-templates select="." mode="code-parenthesis"/>
            </td>
            <td>
                <xsl:call-template name="label-value">
                    <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
                    <xsl:with-param name="value" select="ects/@title"/>
                </xsl:call-template>
            </td>
        </tr>
        <xsl:if test="degree/@id or mention/@id">
            <tr>
                <td>
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_DEGREE'"/>
                        <xsl:with-param name="value" select="degree/@title"/>
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_MENTION'"/>
                        <xsl:with-param name="value" select="mention/@title"/>
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="domain/@id or speciality != ''">
            <tr>
                <td>
                    <xsl:variable name="domains">
                        <xsl:for-each select="domain">
                            <xsl:value-of select="@title"/>
                            <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
                        </xsl:for-each>
                    </xsl:variable>
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_DOMAIN'"/>
                        <xsl:with-param name="value" select="$domains"/>
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_SPECIALITY'"/>
                        <xsl:with-param name="value" select="speciality"/>
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="cms:isNotRichTextEmpty(knowledgeCheck)">
            <tr>
                <td colspan="2"><xsl:apply-templates select="knowledgeCheck"/></td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="subProgram" mode="section-header-line">
        <xsl:variable name="padding" select="count(ancestor::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container'])*4" />
        
        <tr class="new-header">
            <td style="padding-left: {$padding}mm;">
                <strong><xsl:value-of select="title"/></strong>
                <xsl:apply-templates select="." mode="code-parenthesis"/>
            </td>
            <td>
                <xsl:call-template name="label-value">
                    <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
                    <xsl:with-param name="value" select="ects/@title"/>
                </xsl:call-template>
            </td>
        </tr>
        <xsl:if test="cms:isNotRichTextEmpty(knowledgeCheck)">
            <tr>
                <td colspan="2" style="padding-left: {$padding}mm;"><xsl:apply-templates select="knowledgeCheck"/></td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="container" mode="section-header-line">
        <xsl:variable name="padding" select="count(ancestor::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container'])*4" />
        
        <tr class="new-header">
            <td style="padding-left: {$padding}mm;">
                <strong><xsl:value-of select="title"/></strong>
                <xsl:apply-templates select="." mode="code-parenthesis"/>
            </td>
            <td>
                <xsl:call-template name="label-value">
                    <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
                    <xsl:with-param name="value">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="ects" />
                            <xsl:with-param name="showZero" select="false()" />
                        </xsl:call-template>
                    </xsl:with-param>
                </xsl:call-template>
            </td>
        </tr>
        <xsl:if test="nature/@id or period/@id">
            <tr>
                <td style="padding-left: {$padding}mm;">
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_NATURE'"/>
                        <xsl:with-param name="value" select="nature/@title"/>
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_PERIOD'"/>
                        <xsl:with-param name="value" select="period/@title"/>
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="mccCompensable != ''">
            <tr>
                <td style="padding-left: {$padding}mm;">
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_COMPENSABLE'"/>
                        <xsl:with-param name="value" select="mccCompensable"/>
                    </xsl:call-template>
                </td>
                <td/>
            </tr>
        </xsl:if>
        <xsl:if test="justifiedAbsence/@id != '' or unjustifiedAbsence/@id != ''">
            <tr>
                <td style="padding-left: {$padding}mm;">
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ABS_JUSTIF'"/>
                        <xsl:with-param name="value" select="justifiedAbsence/@title"/>
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ABS_INJUSTIF'"/>
                        <xsl:with-param name="value" select="unjustifiedAbsence/@title"/>
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="mccRegime/@id or mccNbSessions != ''">
            <tr>
                <td style="padding-left: {$padding}mm;">
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_REGIME'"/>
                        <xsl:with-param name="value" select="mccRegime/@title"/>
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_NB_SESSIONS'"/>
                        <xsl:with-param name="value" select="mccNbSessions"/>
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="mcc_workflow/mcc_orgunit_validation_date != '' or mcc_workflow/cfvu_mcc_validation_date != ''">
            <tr>
                <td style="padding-left: {$padding}mm;">
                    <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_VALIDATION_DATE_ORGUNIT"/></strong>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                    <i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="mcc_workflow/mcc_orgunit_validation_date"/></i18n:date>
                </td>
                <td>
                    <xsl:if test="mcc_workflow/cfvu_mcc_validation_date != ''">
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_VALIDATION_DATE_CFVU"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                        <i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="mcc_workflow/cfvu_mcc_validation_date"/></i18n:date>
                    </xsl:if>
                </td>
            </tr>
            <xsl:if test="mcc_workflow/mcc_orgunit_validation_comment != '' or mcc_workflow/cfvu_mcc_validation_comment != ''">
                <tr>
                    <td style="padding-left: {$padding}mm;">
                        <xsl:if test="mcc_workflow/mcc_orgunit_validation_comment != ''">
                            <xsl:call-template name="text.nl2br">  
                                <xsl:with-param name="input" select="mcc_workflow/mcc_orgunit_validation_comment"/>
                            </xsl:call-template>
                        </xsl:if>
                    </td>
                    <td>
                        <xsl:if test="mcc_workflow/cfvu_mcc_validation_comment != ''">
                            <xsl:call-template name="text.nl2br">  
                                <xsl:with-param name="input" select="mcc_workflow/cfvu_mcc_validation_comment"/>
                            </xsl:call-template>
                        </xsl:if>
                    </td>
                </tr>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="table-header">
        <xsl:param name="displayMcc2"/>
        
        <thead>
            <tr>
                <td class="maquette" colspan="{$nbColumnsMaquette}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MAQUETTE"/></td>
                <td class="evaluation" colspan="{$nbColumnsElpEval + $nbColumnsMccSession1 + $displayMcc2 * $nbColumnsMccSession2}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATION"/></td>
            </tr>
            <tr>
                <xsl:call-template name="table-header-maquette"/>
                <xsl:call-template name="table-header-evaluation-elp"/>
                <td class="session1" colspan="{$nbColumnsMccSession1}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_1"/></td>
                <xsl:if test="$displayMcc2">
                    <td class="session2" colspan="{$nbColumnsMccSession2}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_2"/></td>
                </xsl:if>
            </tr>
            <tr>
                <xsl:call-template name="table-header-session1"/>
                <xsl:if test="$displayMcc2">
                    <xsl:call-template name="table-header-session2"/>
                </xsl:if>
            </tr>
        </thead>
    </xsl:template>
    
    <xsl:template name="table-header-maquette">
        <!-- 40% -->
        <td class="maquette" style="width: 2%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATED"/></td>
        <td class="maquette" style="width: 5%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_CODE"/></td>
        <td class="maquette" style="width: 3%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NATURE"/></td>
        <td class="maquette" style="width: 15%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_LABEL"/></td>
        <td class="maquette" style="width: 2%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SHARED"/></td>
        <td class="maquette" style="width: 2%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_ECTS"/></td>
        <td class="maquette" style="width: 2%" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_COEF"/></td>
        <td class="maquette" style="width: 2%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NOTE_ELIM"/></td>
        <td class="maquette" style="width: 3%;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_REGIME"/></td>
        <td class="maquette" style="width: 4%;" rowspan="2" colspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_VOLUME_HORAIRE"/></td>
    </xsl:template>
    
    <xsl:template name="table-header-evaluation-elp"/>
    
    <xsl:template name="table-header-session1">
        <!-- 31% -->
        <td class="session1" style="width: 8%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LABEL"/></td>
        <td class="session1" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/></td>
        <td class="session1" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NATURE"/></td>
        <td class="session1" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_DUREE"/></td>
        <td class="session1" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_COEF"/></td>
        <td class="session1" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NOTE_ELIM"/></td>
        <td class="session1" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NB_NOTES"/></td>
        <td class="session1" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_PONDERATION"/></td>
        <td class="session1" style="width: 2%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_REPORT_SESSION_2"/></td>
    </xsl:template>
    
    <xsl:template name="table-header-session2">
        <!-- 29% -->
        <td class="session2" style="width: 8%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LABEL"/></td>
        <td class="session2" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/></td>
        <td class="session2" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NATURE"/></td>
        <td class="session2" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_DUREE"/></td>
        <td class="session2" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_COEF"/></td>
        <td class="session2" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NOTE_ELIM"/></td>
        <td class="session2" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NB_NOTES"/></td>
        <td class="session2" style="width: 3%;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_PONDERATION"/></td>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container">
        <xsl:if test="courseList/course">
            <xsl:call-template name="mcc-table">
                <xsl:with-param name="courseLists" select="courseList[course]"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:apply-templates select="subProgram|container" />
    </xsl:template>
    
    <xsl:template match="courseList">
        <xsl:if test="course">
            <xsl:call-template name="mcc-table">
                <xsl:with-param name="courseLists" select="."/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-table">
        <xsl:param name="courseLists"/>
        
        <xsl:if test="$courseLists/course">
            <xsl:variable name="displayMcc2" select="count($courseLists//course[@session2 = 'available']) > 0"/>
            
            <xsl:call-template name="new-page"/>
            <xsl:call-template name="section-header"/>
            <table class="main">
                <xsl:call-template name="table-header">
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
                <tbody>
                    <xsl:apply-templates select="$courseLists" mode="table-content">
                        <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                    </xsl:apply-templates>
                </tbody>
            </table>
            <xsl:apply-templates select="controles" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="courseList" mode="table-content">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="displayMcc2" />
        
        <xsl:variable name="courseListChoice" select="choiceType/@value"/>
        <xsl:choose>
            <xsl:when test="$courseListChoice = 'CHOICE'">
                <tr class="courselist">
                    <td colspan="{$titleColumnPosition - 1}" class="first-cell"/>
                    <td colspan="{$nbColumns - $titleColumnPosition + 1 - $nbColumnsMccSession2 * not($displayMcc2)}">
                        <xsl:call-template name="recursive-print">
                            <xsl:with-param name="times" select="$depth" />
                        </xsl:call-template>
                        <i18n:translate>
                            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_CHOICE"/>
                            <i18n:param><xsl:value-of select="min" /></i18n:param>
                        </i18n:translate>
                    </td>
                </tr>
            </xsl:when>
            <xsl:when test="$courseListChoice = 'OPTIONAL'">
                <tr class="courselist">
                    <td colspan="{$titleColumnPosition - 1}" class="first-cell"/>
                    <td colspan="{$nbColumns - $titleColumnPosition + 1 - $nbColumnsMccSession2 * not($displayMcc2)}">
                        <xsl:call-template name="recursive-print">
                            <xsl:with-param name="times" select="$depth" />
                        </xsl:call-template>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_OPTIONAL"/>
                    </td>
                </tr>
            </xsl:when>
        </xsl:choose>
        
        <xsl:apply-templates select="course">
            <xsl:with-param name="depth" select="$depth + ($courseListChoice != 'MANDATORY')"/>
            <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="displayMcc2" select="true()"/>
        
        <xsl:variable name="currentCourse" select="."/>
        <xsl:variable name="courseParts">
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <xsl:call-template name="enseignement-cells">
                    <xsl:with-param name="code">
                        <xsl:call-template name="displayCodeOrShortLabel">
                            <xsl:with-param name="contentId" select="@id"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="volumeHoraire" select="$currentCourse/courseParts[nature/@id = current()/@id]/nbHours"/>
                    <xsl:with-param name="mcc1" select="$currentCourse/mcc/mccSession1/entry[natureEnseignement/@id = current()/@id]"/>
                    <xsl:with-param name="mcc2" select="$currentCourse[@session2 = 'available']/mcc/mccSession2/entry[natureEnseignement/@id = current()/@id]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </xsl:for-each>
            
            <!-- Ajouter les lignes sans nature d'enseignement -->
            <xsl:if test="$currentCourse/mcc/*/entry[not(natureEnseignement/@id)]">
                <xsl:call-template name="enseignement-cells">
                    <xsl:with-param name="mcc1" select="$currentCourse/mcc/mccSession1/entry[not(natureEnseignement/@id)]"/>
                    <xsl:with-param name="mcc2" select="$currentCourse[@session2 = 'available']/mcc/mccSession2/entry[not(natureEnseignement/@id)]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="exsl:node-set($courseParts)/row">
                <xsl:for-each select="exsl:node-set($courseParts)/row">
                    <xsl:choose>
                        <xsl:when test="position() = 1">
                            <tr>
                                <xsl:call-template name="course-attributes">
                                    <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                                </xsl:call-template>
                                
                                <xsl:apply-templates select="$currentCourse" mode="cells">
                                    <xsl:with-param name="depth" select="$depth"/>
                                    <!-- Sum all computed rows from course parts and evaluations to get the total course rowspan -->
                                    <xsl:with-param name="courseRowspan" select="count(exsl:node-set($courseParts)/row)"/>
                                </xsl:apply-templates>
                                
                                <xsl:copy-of select="*"/>
                            </tr>
                        </xsl:when>
                        <xsl:otherwise>
                            <tr>
                                <xsl:call-template name="course-attributes">
                                    <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                                    <xsl:with-param name="isFirst" select="false()"/>
                                </xsl:call-template>
                                
                                <xsl:copy-of select="*"/>
                            </tr>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:call-template name="course-attributes">
                        <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                    </xsl:call-template>
                    
                    <xsl:apply-templates select="." mode="cells">
                        <xsl:with-param name="depth" select="$depth"/>
                    </xsl:apply-templates>
                    
                    <xsl:call-template name="mcc-empty-cells">
                        <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                    </xsl:call-template>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:apply-templates select="courseList[course]" mode="table-content">
            <xsl:with-param name="depth" select="$depth + 1"/>
            <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="enseignement-cells">
        <xsl:param name="code"/>
        <xsl:param name="volumeHoraire" select="foo/*"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <xsl:variable name="mccLines" select="double:max(count($mcc1), count($mcc2) * $displayMcc2)"/>
        
        <xsl:if test="count($volumeHoraire) > 0 or $mccLines > 0">
            <xsl:variable name="natureEnseignementRowspan" select="cms:getTotalNotesRowspan($mcc1, $mcc2, $displayMcc2)"/>
            
            <row>
                <td class="nature-ens" rowspan="{$natureEnseignementRowspan}">
                    <xsl:value-of select="$code"/>
                </td>
                <td rowspan="{$natureEnseignementRowspan}">
                    <xsl:if test="$code or count($volumeHoraire) > 0">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="sum($volumeHoraire)"/>
                        </xsl:call-template>
                    </xsl:if>
                </td>
                <xsl:call-template name="mcc">
                    <xsl:with-param name="mcc1" select="$mcc1[1]"/>
                    <xsl:with-param name="mcc2" select="$mcc2[1]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </row>
            
            <!-- Other notes on same MCC session line -->
            <xsl:call-template name="mcc-recursive-row-notes">
                <xsl:with-param name="currentPosition" select="2"/>
                <xsl:with-param name="mcc1" select="$mcc1[1]"/>
                <xsl:with-param name="mcc2" select="$mcc2[1]"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
            
            <!-- Other MCC session lines -->
            <xsl:call-template name="mcc-recursive-row">
                <xsl:with-param name="currentPosition" select="2"/>
                <xsl:with-param name="maxPosition" select="$mccLines"/>
                <xsl:with-param name="mcc1" select="$mcc1"/>
                <xsl:with-param name="mcc2" select="$mcc2"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-recursive-row-notes">
        <xsl:param name="currentPosition"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        <xsl:param name="maxPosition" select="double:max(count($mcc1/notes/entry), count($mcc2/notes/entry) * $displayMcc2)"/>
        
        <xsl:if test="$currentPosition &lt;= $maxPosition">
            <row>
                <!-- session 1 -->
                <xsl:apply-templates select="$mcc1" mode="cell-session-ponderation">
                    <xsl:with-param name="position" select="$currentPosition"/>
                    <xsl:with-param name="suffix"><xsl:apply-templates select="$mcc1" mode="suffix"/></xsl:with-param>
                    <xsl:with-param name="isLast" select="false()"/>
                </xsl:apply-templates>
                
                <!-- session 2 -->
                <xsl:if test="$displayMcc2">
                    <xsl:apply-templates select="$mcc2" mode="cell-session-ponderation">
                        <xsl:with-param name="position" select="$currentPosition"/>
                        <xsl:with-param name="suffix"><xsl:apply-templates select="$mcc2" mode="suffix"/></xsl:with-param>
                    </xsl:apply-templates>
                </xsl:if>
            </row>
            
            <!-- Recursive call -->
            <xsl:call-template name="mcc-recursive-row-notes">
                <xsl:with-param name="currentPosition" select="$currentPosition + 1"/>
                <xsl:with-param name="mcc1" select="$mcc1"/>
                <xsl:with-param name="mcc2" select="$mcc2"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                <xsl:with-param name="maxPosition" select="$maxPosition"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-recursive-row">
        <xsl:param name="currentPosition"/>
        <xsl:param name="maxPosition"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <xsl:if test="$currentPosition &lt;= $maxPosition">
            <row>
                <xsl:call-template name="mcc">
                    <xsl:with-param name="mcc1" select="$mcc1[$currentPosition]"/>
                    <xsl:with-param name="mcc2" select="$mcc2[$currentPosition]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </row>
            
            <!-- Other notes on same MCC session line -->
            <xsl:call-template name="mcc-recursive-row-notes">
                <xsl:with-param name="currentPosition" select="2"/>
                <xsl:with-param name="mcc1" select="$mcc1[$currentPosition]"/>
                <xsl:with-param name="mcc2" select="$mcc2[$currentPosition]"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
            
            <!-- Recursive call -->
            <xsl:call-template name="mcc-recursive-row">
                <xsl:with-param name="currentPosition" select="$currentPosition + 1"/>
                <xsl:with-param name="maxPosition" select="$maxPosition"/>
                <xsl:with-param name="mcc1" select="$mcc1"/>
                <xsl:with-param name="mcc2" select="$mcc2"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="mcc">
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <!-- Rowspan is the max number of notes between the entry of session1 and session2, it there is no notes, it is set to 1 -->
        <xsl:variable name="sessionRowspan" select="double:max(1, double:max(count($mcc1/notes/entry), count($mcc2/notes/entry) * $displayMcc2))"/>
        
        <!-- session 1 -->
        <xsl:call-template name="mcc-session-cells-1">
            <xsl:with-param name="entry" select="$mcc1" />
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan" />
        </xsl:call-template>
        
        <!-- session 2 -->
        <xsl:if test="$displayMcc2">
            <xsl:call-template name="mcc-session-cells-2">
                <xsl:with-param name="entry" select="$mcc2" />
                <xsl:with-param name="sessionRowspan" select="$sessionRowspan" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-session-cells-1">
        <xsl:param name="entry" />
        <xsl:param name="sessionRowspan" />
        
        <xsl:choose>
            <xsl:when test="$entry">
                <xsl:apply-templates select="$entry" mode="mcc-session-cells-non-empty-1">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="mcc-session-empty-cells-1">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="mcc-session-cells-2">
        <xsl:param name="entry" />
        <xsl:param name="sessionRowspan" />
        
        <xsl:choose>
            <xsl:when test="$entry">
                <xsl:apply-templates select="$entry" mode="mcc-session-cells-non-empty-2">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="mcc-session-empty-cells-2">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="entry" mode="suffix"/>
    
    <xsl:template match="entry" mode="mcc-session-cells-non-empty-1">
        <xsl:param name="sessionRowspan" select="1"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <xsl:apply-templates select="." mode="cell-session-label">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-modalite">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nature">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-duree">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-coef">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-note">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nb-notes">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-ponderation">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="isLast" select="false()"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-report">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="mcc-session-cells-non-empty-2">
        <xsl:param name="sessionRowspan" select="1"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <xsl:apply-templates select="." mode="cell-session-label">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-modalite">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nature">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-duree">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-coef">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-note">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nb-notes">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-ponderation">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-label">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="label != ''">
                <strong><xsl:value-of select="label"/></strong>
            </xsl:if>
            <xsl:if test="foreignLanguage/@id">
                <div class="lang">
                    <xsl:call-template name="label-value">
                        <xsl:with-param name="i18nLabelKey">PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LANG</xsl:with-param>
                        <xsl:with-param name="value" select="foreignLanguage/@title"/>
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:if test="remarques != ''">
                <div class="remarques">
                    <xsl:call-template name="text.nl2br">  
                        <xsl:with-param name="input" select="remarques"/>
                    </xsl:call-template>
                </div>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-modalite">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="nombre != ''">
                <xsl:value-of select="nombre" />
                <xsl:if test="modalite/@id">
                    <xsl:text> </xsl:text>
                </xsl:if>
            </xsl:if>
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="modalite/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-nature">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="nature/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-duree">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="duree != ''"><xsl:value-of select="odf:minute2hour(duree)" /></xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-coef">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="coefficient != ''">
                <xsl:choose>
                    <xsl:when test="contains(coefficient, '%') or contains(coefficient, '/')">
                        <xsl:value-of select="coefficient"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="coefficient" />
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-note">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="noteEliminatoire" />
                <xsl:with-param name="showZero" select="true()" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-nb-notes">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:choose>
                <xsl:when test="notes/entry">
                    <xsl:value-of select="count(notes/entry)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="default-nb-notes"/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-ponderation">
        <xsl:param name="position" select="1"/>
        <xsl:param name="suffix"/>
        <xsl:param name="isLast" select="true()"/>
        
        <xsl:variable name="value" select="notes/entry[$position]/ponderation"/>
        
        <xsl:variable name="class"><xsl:if test="not($isLast)">session-cell-</xsl:if>centered<xsl:value-of select="$suffix"/></xsl:variable>
        <td class="{$class}">
            <xsl:choose>
                <xsl:when test="$value">
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="$value"/>
                        <xsl:with-param name="showZero" select="true()" />
                        <xsl:with-param name="format" select="'#,##'"/>
                    </xsl:call-template>
                    <xsl:text>%</xsl:text>
                </xsl:when>
                <xsl:when test="$position = 1">
                    <xsl:call-template name="default-ponderation"/>
                </xsl:when>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-report">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="reportSession2 = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cells">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="courseRowspan" select="1"/>
        
        <xsl:apply-templates select="." mode="cell-course-evaluated">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-code">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-nature">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-label">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
            <xsl:with-param name="depth" select="$depth"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-shared">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-ects">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-coef">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-note">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-regime">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-evaluated">
        <xsl:param name="courseRowspan"/>
        <td class="first-cell" rowspan="{$courseRowspan}">
            <xsl:if test="not(isEvaluated) or isEvaluated = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-code">
        <xsl:param name="courseRowspan"/>
        <td class="codeAmetys" rowspan="{$courseRowspan}">
            <xsl:apply-templates select="." mode="code"/>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-nature">
        <xsl:param name="courseRowspan"/>
        <td rowspan="{$courseRowspan}">
            <xsl:value-of select="courseType/code" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-label">
        <xsl:param name="courseRowspan"/>
        <xsl:param name="depth"/>
        <td rowspan="{$courseRowspan}">
            <!-- Identation. Print 4 spaces per level -->
            <xsl:call-template name="recursive-print">
                <xsl:with-param name="times" select="$depth" />
            </xsl:call-template>
            <xsl:value-of select="title" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-shared">
        <xsl:param name="courseRowspan"/>
        <td class="centered" rowspan="{$courseRowspan}">
            <xsl:if test="isShared = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-ects">
        <xsl:param name="courseRowspan"/>
        <td class="centered" rowspan="{$courseRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="odf:getEcts(@id, @path)" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-coef">
        <xsl:param name="courseRowspan"/>
        <td class="centered" rowspan="{$courseRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="odf:getValueForPath(@id, 'mccCoefficientByEducationalPath/coefficient', @path, 'mccCoefficient')" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-regime">
        <xsl:param name="courseRowspan"/>
        <td rowspan="{$courseRowspan}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="mccRegime/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-note">
        <xsl:param name="courseRowspan"/>
        <td rowspan="{$courseRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="mccNoteEliminatoire" />
                <xsl:with-param name="showZero" select="true()" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template name="mcc-empty-cells">
        <xsl:param name="displayMcc2" />
        
        <xsl:call-template name="volume-horaire-empty-cells" />
        <xsl:call-template name="mcc-session-empty-cells-1" />
        <xsl:if test="$displayMcc2">
            <xsl:call-template name="mcc-session-empty-cells-2" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="volume-horaire-empty-cells">
        <td colspan="2"/>
    </xsl:template>
    
    <xsl:template name="mcc-session-empty-cells-1">
        <xsl:param name="sessionRowspan" select="1"/>
        <td colspan="{$nbColumnsMccSession1}" rowspan="{$sessionRowspan}"/>
    </xsl:template>
    
    <xsl:template name="mcc-session-empty-cells-2">
        <xsl:param name="sessionRowspan" select="1"/>
        <td colspan="{$nbColumnsMccSession2}" rowspan="{$sessionRowspan}"/>
    </xsl:template>
    
    <xsl:template match="knowledgeCheck|controles">
        <xsl:if test="cms:isNotRichTextEmpty(.)">
            <xsl:apply-templates select="docbook:article">
                <xsl:with-param name="level" select="3"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="course-attributes">
        <xsl:param name="type"/>
        <xsl:param name="isFirst" select="true()"/>
        
        <xsl:attribute name="class">
            <xsl:choose>
                <xsl:when test="$type='UE'"><xsl:if test="$isFirst">first-</xsl:if>ue</xsl:when>
                <xsl:otherwise>elp</xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template name="label-value">
        <xsl:param name="i18nLabelKey"/>
        <xsl:param name="value"/>
        
        <xsl:if test="$value != ''">
            <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="{$i18nLabelKey}"/></strong>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
            <xsl:value-of select="$value"/>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
