<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc2pdf.xsl"/>
    
    <xsl:template name="catalog-title">
        <fo:block xsl:use-attribute-sets="h2">
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_DIFF_HEADER_CATALOG"/>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
            <xsl:apply-templates select="." mode="catalog"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="h2">
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_DIFF_HEADER_CATALOG_OLD"/>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
            <xsl:value-of select="/report/catalogOld"/>
        </fo:block>
    </xsl:template>
    
    <xsl:template match="entry[@changeType = 'added']" mode="style">
        <xsl:attribute name="text-decoration">underline</xsl:attribute>
        <xsl:attribute name="color">green</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="entry[@changeType = 'removed']" mode="style">
        <xsl:attribute name="text-decoration">line-through</xsl:attribute>
        <xsl:attribute name="color">red</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="entry[@changeType = 'modified_old']" mode="style">
        <xsl:attribute name="text-decoration">line-through</xsl:attribute>
        <xsl:attribute name="border-bottom">1px white solid</xsl:attribute>
        <xsl:attribute name="color">#cccccc</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="entry[@changeType = 'modified_new']" mode="style">
        <xsl:attribute name="text-decoration">underline</xsl:attribute>
        <xsl:attribute name="color">blue</xsl:attribute>
    </xsl:template>
</xsl:stylesheet>
