/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.HashMap;
import java.util.Map;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.odf.coursepart.CoursePartFactory;
import org.ametys.runtime.model.ModelItem;

/**
 * Override the TreeTooClientSideElement to retrieve informations for the CoursePart tool
 */
public class CoursePartClientSideElement extends CostModelingClientSideElement
{
    
    @Override
    protected void _lazyConfigure()
    {
        super._lazyConfigure();
        _script.getParameters().put("nbHours", getNbHours());
    }
    
    private Map<String, Object> getNbHours()
    {
        ContentType contentType = _contentTypeExtensionPoint.getExtension(CoursePartFactory.COURSE_PART_CONTENT_TYPE);
        
        ModelItem modelItem = contentType.getModelItem("nbHours");

        Map<String, Object> result = new HashMap<>();
        result.put("widget", modelItem.getWidget());
        result.put("widget-params", modelItem.getWidgetParameters());
        result.put("type", modelItem.getType().getId());
        return result;
    }
}
