/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.validator;

/**
 * Global validator for Norme content.
 * Check that every instance of the repeater groupEffectives have a different natureEnseignement.
 */
public class NormeValidator extends AbstractRepeaterWithUniqueContentValidator
{
    @Override
    protected String getRepeaterName()
    {
        return "groupEffectives";
    }

    @Override
    protected String getContentDataName()
    {
        return "natureEnseignement";
    }

    @Override
    protected String getErrorKey()
    {
        return "PLUGINS_ODF_PILOTAGE_NORME_VALIDATOR_ERROR";
    }
}
