<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:su="org.ametys.core.util.StringUtils"
    exclude-result-prefixes="su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    
    <xsl:template name="table-head">
        <tr>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_POTENTIEL_ENSEIGNANT_DISCIPLINE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_POTENTIEL_ENSEIGNANT_POTENTIEL"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_POTENTIEL_ENSEIGNANT_HEURES"/></th>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-body">
        <!-- For each discipline -->
        <xsl:for-each select="items[@contentTypeId = 'odf-enumeration.DisciplineEnseignement']/item">
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="text()"/>
            
            <xsl:call-template name="discipline-report-line"/>
        </xsl:for-each>
        <!-- For the empty discipline -->
        <xsl:call-template name="report-line"/>
    </xsl:template>
    
    <xsl:template name="discipline-report-line">
        <xsl:call-template name="report-line">
            <xsl:with-param name="disciplineId" select="@id"/>
            <xsl:with-param name="disciplineText" select="text()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="report-line">
        <xsl:param name="disciplineId" select="''"/>
        <xsl:param name="disciplineText" select="'(vide)'"/>
    
        <xsl:variable name="potentiel" select="/report/potentiels/entry[discipline = $disciplineId]/potentiel"/>
        <xsl:variable name="sumNbHours" select="/report/sumsByDiscipline/sum[@discipline = $disciplineId]"/>
        
        <!-- If one of the value of $potentiel or $sumNbHours is not empty, display the discipline line -->
        <xsl:if test="$potentiel != '' or $sumNbHours != ''">
            <tr>
                <td><xsl:value-of select="su:sanitizeXlsHtml($disciplineText)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml($potentiel)"/></td>
                <td>
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="$sumNbHours" />
                        <xsl:with-param name="showZero" select="true()" />
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
