<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:cms="http://ametys.org/cms/3.0" 
    exclude-result-prefixes="docbook"
    extension-element-prefixes="cms">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/doc.xsl"/>
    
    <xsl:template name="css-styles">
        body 
        {
            font-size: 10pt;
        }
        
        h1, h2, h3
        {
            text-align: center;
        }
    </xsl:template>
    
    <xsl:template name="doc-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_TITLE"/> - <xsl:value-of select="program/@title" />
    </xsl:template>
    
    <xsl:template name="footer">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_COPYRIGHT"/>
    </xsl:template>

    <xsl:template name="body">
        <xsl:apply-templates select="program" />
        <xsl:apply-templates select="subprogram" />
    </xsl:template>
    
    <xsl:template match="program">
        <h1><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_TITLE"/></h1>
        <h2><xsl:value-of select="@title" /></h2>
        
        <ul>
            <xsl:if test="mention"><li><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_MENTION"/><xsl:value-of select="mention"/></li></xsl:if>
            <xsl:if test="degree"><li><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_DEGREE"/><xsl:value-of select="degree"/></li></xsl:if>
            <xsl:if test="count(domain) > 0">
                <li><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_DOMAINS"/>
                    <ul>
                        <xsl:for-each select="domain">
                            <li><xsl:value-of select="."/> - <xsl:value-of select="@code"/></li>
                        </xsl:for-each>
                    </ul>
                </li>
            </xsl:if>
            <li><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_YEAR"/><xsl:value-of select="catalog"/></li>
            <xsl:if test="@CFVUDate">
                <li><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_REGLEMENT_ETUDES_DATE_VALIDATION_CFVU"/><i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="@CFVUDate" /></i18n:date></li>
            </xsl:if>
        </ul>
        
        <xsl:if test="cms:isNotRichTextEmpty(reglementEtudes)">
            <xsl:apply-templates select="reglementEtudes/docbook:article">
                <xsl:with-param name="level" select="3"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="subprogram">
        <xsl:if test="cms:isNotRichTextEmpty(reglementEtudes)">
            <h3><xsl:value-of select="@title" /></h3>
            
            <xsl:apply-templates select="reglementEtudes/docbook:article">
                <xsl:with-param name="level" select="4"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
