<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:cms="http://ametys.org/cms/3.0"
                exclude-result-prefixes="i18n cms docbook">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/doc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/functions.xsl" />
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/common.xsl"/>
    
    <xsl:param name="showArchived" select="true()"/>
    
    <xsl:template name="css-styles">
        #<xsl:value-of select="$uniqueSectionId"/> body,
        #<xsl:value-of select="$uniqueSectionId"/> p
        {
            font-size: 10pt;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> h1
        {
            font-size: 140%;
            color: <xsl:value-of select="$mainColor" />;
            text-align: center;
            margin: 2pt;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> h2
        {
            font-size: 130%;
            color: <xsl:value-of select="$mainColor" />;
            text-align: center;
            margin: 2pt;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> h3
        {
            font-size: 10pt;
            margin-top: 18pt;
            margin-bottom: 5pt;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> div.header-title {
            margin-bottom:1cm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic {
            width: 18cm;
            margin-right: 5mm;
            margin-left: 5mm;
            padding: 0px;
            border-spacing: 0;
            border-collapse: collapse;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td {
            margin-top: 2mm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td.thematic-title {
            font-weight: bold;
            color: <xsl:value-of select="$mainColor" />;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td.thematic-code {
            text-align: right;
            font-size: 80%;
            color: <xsl:value-of select="$mainColor" />;
            width: 4cm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic tr.intermediate-line td {
            border-bottom: solid thin lightgrey;
            margin-bottom: 2mm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td.rule-code {
            text-align: right;
            font-size: 80%;
            color: #808080;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> hr {
            border-top: solid thin #808080;
            margin: 5mm;
        }
        
        <xsl:call-template name="additional-css-styles"/>
    </xsl:template>
    
    <xsl:template name="additional-css-styles"/>
    
    <xsl:template name="footer">
        <xsl:call-template name="doc-title"/>
    </xsl:template>
    
    <xsl:template name="contents">
        <xsl:param name="contents"/>
        
        <xsl:apply-templates select="$contents">
            <xsl:sort select="cms:getOrder(order)" data-type="number"/>
            <xsl:sort select="title" order="ascending"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="content">
        <xsl:if test="position() > 1">
            <hr/>
        </xsl:if>
        
        <table class="thematic">
            <xsl:call-template name="thematic-title"/>
            <xsl:call-template name="thematic-scope"/>
            <xsl:apply-templates select="rules"/>
        </table>
    </xsl:template>
    
    <xsl:template name="thematic-title">
        <tr style="page-break-after:avoid;">
            <td class="thematic-title"><xsl:value-of select="title"/></td>
            <td class="thematic-code">
                <xsl:value-of select="code"/>
                <xsl:if test="archived = 'true'">
                    <xsl:text> </xsl:text>[<i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_ARCHIVED" i18n:catalogue="plugin.odf-pilotage"/>]
                </xsl:if>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="thematic-scope"/>
    
    <xsl:template match="rules">
        <xsl:for-each select="entry[$showArchived or not(archived = 'true')]">
            <tr>
                <xsl:if test="position() != last()">
                    <xsl:attribute name="class">intermediate-line</xsl:attribute>
                </xsl:if>
                <td>
                    <xsl:apply-templates select="text/docbook:article"/>
                </td>
                <td class="rule-code">
                    <xsl:value-of select="code"/>
                    <xsl:if test="status/@value != 'NON_MODIFIED'">
                        <xsl:text> </xsl:text>[<i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RULE_STATUS_ENUM_{status/@value}" i18n:catalogue="plugin.odf-pilotage"/>]
                    </xsl:if>
                    <xsl:if test="isDerogable = 'true'">
                        <br/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_DEROGATION" i18n:catalogue="plugin.odf-pilotage"/>
                    </xsl:if>
                </td>
            </tr>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="doc-title">
        <i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_TITLE" catalogue="plugin.odf-pilotage"/>
    </xsl:template>
</xsl:stylesheet>
