<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:cms="http://ametys.org/cms/3.0"
                exclude-result-prefixes="i18n cms docbook">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/common2doc.xsl"/>
    
    <xsl:param name="showArchived" select="false()"/>
    
    <xsl:variable name="degree" select="/export/filters/degree"/>
    <xsl:variable name="groups" select="/export/groups"/>
    
    <xsl:template name="additional-css-styles">
        #<xsl:value-of select="$uniqueSectionId"/> div.header-title {
            margin-top:0;
            margin-bottom:1cm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic {
            width: 18cm;
            margin-right: 5mm;
            margin-left: 5mm;
            padding: 0px;
            border-spacing: 0;
            border-collapse: collapse;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td {
            margin-top: 2mm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td.thematic-title {
            text-align: right;
            font-size: 80%;
            color: <xsl:value-of select="$mainColor" />;
            width: 4cm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td.thematic-code {
            text-align: right;
            font-size: 80%;
            color: <xsl:value-of select="$mainColor" />;
            width: 4cm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic tr.intermediate-line td {
            border-bottom: solid thin lightgrey;
            margin-bottom: 2mm;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.thematic td.rule-code {
            text-align: right;
            font-size: 80%;
            color: #808080;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> .thematic-title {
            font-weight: bold;
            color: <xsl:value-of select="$mainColor" />;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> .thematics-scope {
            background-color: lightgrey;
            padding: 0;
            margin-top: 3mm;
            margin-bottom: 5mm;
            border: solid 1.5pt <xsl:value-of select="$mainColor" />;
            font-size: 90%;
            padding: 1mm;
            page-break-after:avoid;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> hr {
            border-top: solid thin #808080;
            margin: 5mm;
        }
    </xsl:template>
    
    <xsl:template name="body">
        <div class="header-title">
            <xsl:call-template name="title"/>
        </div>
        
        <!-- RG without number of sessions restrictions -->
        <xsl:variable name="contentsWithoutNbSessions" select="contents/content[not(nbSessions)]"/>
        <xsl:if test="$contentsWithoutNbSessions">
            <!-- RG without regime restrictions -->
            <xsl:call-template name="thematics-with-scope">
                <xsl:with-param name="contents" select="$contentsWithoutNbSessions[not(regime)]"/>
                <xsl:with-param name="isFirst" select="true()"/>
            </xsl:call-template>
            
            <!-- RG with regime restrictions -->
            <xsl:for-each select="$groups/items[@contentTypeId = 'odf-enumeration.MccRegime']/item">
                <xsl:sort select="@order" data-type="number"/>
                <xsl:sort select="@code"/>
                
                <xsl:call-template name="thematics-with-scope">
                    <xsl:with-param name="regime" select="current()"/>
                    <xsl:with-param name="contents" select="$contentsWithoutNbSessions[regime/@id = current()/@id]"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:if>
        
        <!-- RG with number of sessions restrictions -->
        <xsl:variable name="contentsWithNbSessions" select="contents/content[nbSessions]"/>
        <xsl:if test="$contentsWithNbSessions">
            <xsl:for-each select="$groups/nbSessions/entry">
                <xsl:variable name="nbSessions" select="current()"/>
                <xsl:variable name="filteredContentsWithNbSessions" select="$contentsWithNbSessions[nbSessions/@value = $nbSessions/@key]"/>
                
                <!-- RG without regime restrictions -->
                <xsl:call-template name="thematics-with-scope">
                    <xsl:with-param name="nbSessions" select="$nbSessions"/>
                    <xsl:with-param name="contents" select="$filteredContentsWithNbSessions[not(regime)]"/>
                </xsl:call-template>
                
                <!-- RG with regime restrictions -->
                <xsl:for-each select="$groups/items[@contentTypeId = 'odf-enumeration.MccRegime']/item">
                    <xsl:sort select="@order" data-type="number"/>
                    <xsl:sort select="@code"/>
                    
                    <xsl:call-template name="thematics-with-scope">
                        <xsl:with-param name="nbSessions" select="$nbSessions"/>
                        <xsl:with-param name="regime" select="current()"/>
                        <xsl:with-param name="contents" select="$filteredContentsWithNbSessions[regime/@id = current()/@id]"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="thematics-with-scope">
        <xsl:param name="nbSessions" select="foo"/>
        <xsl:param name="regime" select="foo"/>
        <xsl:param name="isFirst" select="false()"/>
        <xsl:param name="contents"/>
        
        <xsl:if test="$contents">
            <xsl:if test="not($isFirst)">
                <p><xsl:call-template name="new-page"/></p>
            </xsl:if>
            
            <xsl:call-template name="thematics-scope">
                <xsl:with-param name="nbSessions" select="$nbSessions"/>
                <xsl:with-param name="regime" select="$regime"/>
            </xsl:call-template>
            <xsl:call-template name="contents">
                <xsl:with-param name="contents" select="$contents"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="thematics-scope">
        <xsl:param name="nbSessions" select="foo"/>
        <xsl:param name="regime" select="foo"/>
        
        <p class="thematics-scope">
            <i18n:translate>
                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_APPLICABLE_THEMATICS" i18n:catalogue="plugin.odf-pilotage"/>
                <i18n:param name="degree"><xsl:value-of select="$degree"/></i18n:param>
            </i18n:translate>
            <xsl:if test="$nbSessions">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_APPLICABLE_THEMATICS_NB_SESSIONS" i18n:catalogue="plugin.odf-pilotage"/>
                    <i18n:param name="nbSessions"><xsl:value-of select="$nbSessions"/></i18n:param>
                </i18n:translate>
            </xsl:if>
            <xsl:if test="$regime">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_APPLICABLE_THEMATICS_REGIME" i18n:catalogue="plugin.odf-pilotage"/>
                    <i18n:param name="regime"><xsl:value-of select="$regime"/></i18n:param>
                </i18n:translate>
            </xsl:if>
        </p>
    </xsl:template>
    
    <xsl:template name="title">
        <h1><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_TITLE" catalogue="plugin.odf-pilotage"/></h1>
        <h2><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_SUBTITLE" catalogue="plugin.odf-pilotage"/> - <xsl:value-of select="$degree"/></h2>
        <h2><xsl:value-of select="filters/catalog"/></h2>
    </xsl:template>
</xsl:stylesheet>
