/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.cost;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationDataCache;
import org.ametys.plugins.odfpilotage.cost.entity.Effectives;
import org.ametys.plugins.odfpilotage.cost.entity.EqTD;
import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.NormDetails;
import org.ametys.plugins.odfpilotage.cost.entity.OverriddenData;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.cost.entity.VolumesOfHours;
import org.ametys.plugins.odfpilotage.cost.eqtd.EqTDComputationMode;
import org.ametys.plugins.odfpilotage.cost.eqtd.EqTDComputationModeExtensionPoint;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CostComputationComponent
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = CostComputationComponent.class.getName();
    private static final String __EFFECTIF_ESTIMATED = "numberOfStudentsEstimated";
    private OdfReferenceTableHelper _refTableHelper;
    private PilotageHelper _pilotageHelper;
    private ODFHelper _odfHelper;
    private EqTDComputationModeExtensionPoint _eqTDComputationModeEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._eqTDComputationModeEP = (EqTDComputationModeExtensionPoint)((Object)manager.lookup(EqTDComputationModeExtensionPoint.ROLE));
    }

    public CostComputationData computeCostsOnOrgUnit(OrgUnit orgUnit, String catalog, String lang, boolean needsAdditionalComputation) {
        return this.computeCostsOnOrgUnit(orgUnit, catalog, lang, needsAdditionalComputation, new OverriddenData(), false);
    }

    public CostComputationData computeCostsOnOrgUnit(OrgUnit orgUnit, String catalog, String lang, boolean needsAdditionalComputation, OverriddenData overriddenData, boolean checkEffectiveConsistency) {
        List programs = this._odfHelper.getProgramsFromOrgUnit(orgUnit, catalog, lang);
        CostComputationDataCache cache = this._computeCostsOnPrograms(programs, needsAdditionalComputation, overriddenData, checkEffectiveConsistency);
        Effectives effectives = new Effectives();
        VolumesOfHours volumesOfHours = new VolumesOfHours();
        EqTD eqTD = new EqTD();
        Double localEqTD = 0.0;
        Double proratedEqTD = 0.0;
        Double localEffective = 0.0;
        for (Program program : programs) {
            String programId = program.getId();
            localEffective = localEffective + Optional.of(programId).map(cache::getEffectives).map(eff -> eff.getLocalEffective(program.getName())).orElse(0.0);
            volumesOfHours.sum(cache.getVolumesOfHours(programId), 1.0);
            EqTD programEqTD = cache.getEqTD(programId);
            eqTD.sum(programEqTD);
            localEqTD = localEqTD + programEqTD.getLocalEqTD().values().stream().reduce(0.0, Double::sum);
            proratedEqTD = proratedEqTD + programEqTD.getProratedEqTD().values().stream().reduce(0.0, Double::sum);
        }
        String orgUnitName = orgUnit.getName();
        effectives.addLocalEffective(orgUnitName, localEffective);
        eqTD.addLocalEqTD(orgUnitName, localEqTD);
        eqTD.addProratedEqTD(orgUnitName, proratedEqTD);
        String orgUnitId = orgUnit.getId();
        cache.putEffectives(orgUnitId, effectives);
        cache.putVolumesOfHours(orgUnitId, volumesOfHours);
        cache.putEqTD(orgUnitId, eqTD);
        return cache.getCostComputationData();
    }

    public CostComputationData computeCostsOnPrograms(List<Program> programs, boolean needsAdditionalComputation) {
        return this.computeCostsOnPrograms(programs, needsAdditionalComputation, new OverriddenData(), false);
    }

    public CostComputationData computeCostsOnPrograms(List<Program> programs, boolean needsAdditionalComputation, OverriddenData overriddenData, boolean checkEffectiveConsistency) {
        return this._computeCostsOnPrograms(programs, needsAdditionalComputation, overriddenData, checkEffectiveConsistency).getCostComputationData();
    }

    protected CostComputationDataCache _computeCostsOnPrograms(List<Program> programs, boolean needsAdditionalComputation, OverriddenData overriddenData, boolean checkEffectiveConsistency) {
        CostComputationDataCache cache = new CostComputationDataCache(programs, this._refTableHelper.getItems("odf-enumeration.Norme"), this._refTableHelper.getItems("odf-enumeration.EnseignementNature"), this._odfHelper.getYearId().orElse(null), overriddenData);
        for (Program program : programs) {
            this._searchAndComputeCourseParts((ProgramItem)program, cache);
            this._computeLocalValues((ProgramItem)program, program.getName(), null, null, cache);
            if (!checkEffectiveConsistency) continue;
            this._checkEffectiveConsistency((ProgramItem)program, cache);
        }
        if (needsAdditionalComputation) {
            CostComputationData costData = cache.getCostComputationData();
            for (String itemId : costData.keySet()) {
                ProgramItemData itemData = (ProgramItemData)costData.get(itemId);
                if (!itemData.isCoursePart()) continue;
                Effectives effectives = itemData.getEffectives();
                for (String path : itemData.getPathes()) {
                    if (effectives.getLocalEffective(path) != null) continue;
                    String parentId = null;
                    Object currentPath = "";
                    for (Content contentInPath : this._pilotageHelper.getContentsFromPath(path).toList()) {
                        currentPath = (String)currentPath + contentInPath.getName();
                        String contentInPathId = contentInPath.getId();
                        Supplier<Double> weightSupplier = () -> {
                            double d;
                            if (contentInPath instanceof Program) {
                                Program programItem = (Program)contentInPath;
                                d = this._getWeight((ProgramItem)programItem, cache);
                            } else {
                                d = 1.0;
                            }
                            return d;
                        };
                        this._computeLocalEffective(contentInPathId, (String)currentPath, parentId, weightSupplier, cache);
                        currentPath = (String)currentPath + "/";
                    }
                    this._computeProratedEqTD(itemId, path, cache);
                }
            }
        }
        for (Program program : programs) {
            this._localEqTD((ProgramItem)program, program.getName(), cache);
        }
        return cache;
    }

    private void _computeLocalValues(ProgramItem programItem, String currentPath, String parentProgramItemId, Container currentStep, CostComputationDataCache cache) {
        String programItemId = programItem.getId();
        if (this._computeLocalEffective(programItemId, currentPath, parentProgramItemId, () -> this._getWeight(programItem, cache), cache)) {
            Course course;
            Double proratedEqTD = 0.0;
            if (programItem instanceof Course && !(course = (Course)programItem).hasCourseLists()) {
                for (CoursePart coursePart : course.getCourseParts()) {
                    String coursePartId = coursePart.getId();
                    String coursePartPath = currentPath + "/" + coursePart.getName();
                    this._computeLocalEffective(coursePartId, coursePartPath, programItemId, () -> 1.0, cache);
                    this._computeLocalEqTD(coursePart, course, coursePartPath, currentStep, cache);
                    proratedEqTD = proratedEqTD + this._computeProratedEqTD(coursePartId, coursePartPath, cache);
                }
            } else {
                Container newCurrentStep = this._odfHelper.isContainerOfNature(programItem, cache.getYearNature()) ? (Container)programItem : currentStep;
                Effectives effectives = cache.getEffectives(programItemId);
                boolean cumulateLocalEffectiveBySum = currentStep == null && effectives.getEstimatedEffectiveByPath().isEmpty();
                Double cumulatedLocalEffective = 0.0;
                List children = this._odfHelper.getChildProgramItems(programItem);
                for (ProgramItem child : children) {
                    String childPath = currentPath + "/" + child.getName();
                    this._computeLocalValues(child, childPath, programItemId, newCurrentStep, cache);
                    proratedEqTD = proratedEqTD + cache.getEqTD(child.getId()).getProratedEqTD(childPath);
                    if (!cumulateLocalEffectiveBySum) continue;
                    cumulatedLocalEffective = cumulatedLocalEffective + Optional.of(child).map(AmetysObject::getId).map(cache::getEffectives).map(eff -> eff.getLocalEffective(childPath)).orElse(0.0);
                }
                if (cumulateLocalEffectiveBySum) {
                    effectives.addLocalEffective(currentPath, cumulatedLocalEffective);
                    cache.putEffectives(programItemId, effectives);
                }
            }
            this._addProratedEqTD(programItemId, currentPath, proratedEqTD, cache);
        }
    }

    private void _checkEffectiveConsistency(ProgramItem programItem, CostComputationDataCache cache) {
        List children = this._odfHelper.getChildProgramItems(programItem);
        Double globalEffective = this._getEstimatedEffective(programItem, cache);
        if (globalEffective != null) {
            CourseList list;
            Course course;
            if (programItem instanceof Course && this._checkCourseConsistencyWithParent(cache, globalEffective, course = (Course)programItem)) {
                this._setInconsistent(cache, (ProgramItem)course);
            } else if (programItem instanceof CourseList && this._checkListConsistency(list = (CourseList)programItem, cache, children, globalEffective)) {
                this._setInconsistent(cache, (ProgramItem)list);
                if (list.getType().equals((Object)CourseList.ChoiceType.CHOICE)) {
                    for (ProgramItem child : children) {
                        this._setInconsistent(cache, child);
                    }
                }
            }
        }
        for (ProgramItem child : children) {
            this._checkEffectiveConsistency(child, cache);
        }
    }

    private Double _getEstimatedEffective(ProgramItem programItem, CostComputationDataCache cache) {
        if (programItem instanceof CourseList) {
            Double globalEffective = 0.0;
            List programItemParents = this._odfHelper.getParentProgramItems(programItem);
            for (ProgramItem parent : programItemParents) {
                globalEffective = globalEffective + this._getEstimatedEffective(parent, cache);
            }
            return globalEffective;
        }
        Effectives effectives = cache.getEffectives(programItem.getId());
        return Optional.ofNullable(effectives).flatMap(Effectives::getEstimatedEffective).orElse(0.0);
    }

    private Double _getSharedEffectiveMin(CourseList current, List<ProgramItem> parents, CostComputationDataCache cache) {
        Double min = 0.0;
        for (ProgramItem parent : parents) {
            if (parent.getId().equals(current.getId()) || !((CourseList)parent).getType().equals((Object)CourseList.ChoiceType.MANDATORY)) continue;
            min = min + this._getEstimatedEffective(parent, cache);
        }
        return min;
    }

    private Double _getSharedEffectiveMax(CourseList current, List<ProgramItem> parents, CostComputationDataCache cache) {
        Double max = 0.0;
        for (ProgramItem parent : parents) {
            if (parent.getId().equals(current.getId())) continue;
            max = max + this._getEstimatedEffective(parent, cache);
        }
        return max;
    }

    private Double _getEffectiveMin(CourseList parent, CostComputationDataCache cache) {
        return parent.getType().equals((Object)CourseList.ChoiceType.MANDATORY) ? this._getEstimatedEffective((ProgramItem)parent, cache) : 0.0;
    }

    private boolean _checkListConsistency(CourseList list, CostComputationDataCache cache, List<ProgramItem> children, Double globalEffective) {
        Double cumulatedGlobalEffective = 0.0;
        Double cumulatedEffectiveMutMin = 0.0;
        Double cumulatedEffectiveMutMax = 0.0;
        for (ProgramItem child : children) {
            List parentProgramItems = this._odfHelper.getParentProgramItems(child);
            if (parentProgramItems.size() > 1) {
                cumulatedEffectiveMutMin = cumulatedEffectiveMutMin + this._getSharedEffectiveMin(list, parentProgramItems, cache);
                cumulatedEffectiveMutMax = cumulatedEffectiveMutMax + this._getSharedEffectiveMax(list, parentProgramItems, cache);
            }
            cumulatedGlobalEffective = cumulatedGlobalEffective + this._getEstimatedEffective(child, cache);
        }
        Double min = switch (list.getType()) {
            case CourseList.ChoiceType.CHOICE -> (double)list.getMinNumberOfCourses() * globalEffective;
            case CourseList.ChoiceType.MANDATORY -> cumulatedEffectiveMutMin + globalEffective * (double)children.size();
            default -> cumulatedEffectiveMutMin;
        };
        Double max = switch (list.getType()) {
            case CourseList.ChoiceType.CHOICE -> list.hasValue("max") ? cumulatedEffectiveMutMax + (double)list.getMaxNumberOfCourses() * globalEffective : cumulatedEffectiveMutMax + globalEffective * (double)children.size();
            default -> cumulatedEffectiveMutMax + globalEffective * (double)children.size();
        };
        long cumulatedlEffectiveRound = Math.round(cumulatedGlobalEffective);
        if (Math.round(min) > cumulatedlEffectiveRound || Math.round(max) < cumulatedlEffectiveRound) {
            this.getLogger().warn("Cumulated global effective for courseList {} ({}) is not set between min ({}) and max ({}) cumulated effectives", new Object[]{list.getId(), cumulatedGlobalEffective, min, max});
            return true;
        }
        return false;
    }

    private boolean _checkCourseConsistencyWithParent(CostComputationDataCache cache, Double globalEffective, Course course) {
        List parentProgramItems = this._odfHelper.getParentProgramItems((ProgramItem)course);
        Double effectiveMin = 0.0;
        Double effectiveMax = 0.0;
        for (ProgramItem parent : parentProgramItems) {
            effectiveMin = effectiveMin + this._getEffectiveMin((CourseList)parent, cache);
            effectiveMax = effectiveMax + this._getEstimatedEffective(parent, cache);
        }
        if (globalEffective < effectiveMin || globalEffective > effectiveMax) {
            this.getLogger().warn("Global effective for programItem {} ({}) is not set between its parent(s) min ({}) and max ({}) global effectives", new Object[]{course.getId(), globalEffective, effectiveMin, effectiveMax});
            return true;
        }
        return false;
    }

    private void _setInconsistent(CostComputationDataCache cache, ProgramItem child) {
        Effectives effectives = cache.getEffectives(child.getId());
        effectives.setInconsistentWithParent(true);
    }

    private Double _computeProratedEqTD(String programItemId, String currentPath, CostComputationDataCache cache) {
        Effectives effectives = cache.getEffectives(programItemId);
        Double localEffectives = effectives.getLocalEffective(currentPath);
        if (localEffectives != null) {
            Double ratioGlobalEffectives = effectives.getEstimatedEffective().filter(d -> d != 0.0).map(d -> localEffectives / d).orElse(0.0);
            EqTD eqTD = cache.getEqTD(programItemId);
            eqTD.addProratedEqTD(currentPath, eqTD.getGlobalEqTD() * ratioGlobalEffectives);
            cache.putEqTD(programItemId, eqTD);
            return eqTD.getProratedEqTD(currentPath);
        }
        return 0.0;
    }

    private void _addProratedEqTD(String programItemId, String currentPath, Double proratedEqTD, CostComputationDataCache cache) {
        EqTD eqTD = cache.getEqTD(programItemId);
        eqTD.addProratedEqTD(currentPath, proratedEqTD);
        cache.putEqTD(programItemId, eqTD);
    }

    private boolean _computeLocalEffective(String programItemId, String currentPath, String parentProgramItemId, Supplier<Double> weightSupplier, CostComputationDataCache cache) {
        Effectives effectives = cache.getEffectives(programItemId);
        if (effectives.getLocalEffective(currentPath) != null) {
            return false;
        }
        effectives.getOverriddenEffective().or(effectives::getEnteredEffective).map(eff -> eff / (double)this._getNbPathes(programItemId, cache).intValue()).or(() -> this._computeLocalEffectiveFromParent(currentPath, parentProgramItemId, weightSupplier, cache)).ifPresent(localEffective -> effectives.addLocalEffective(currentPath, (Double)localEffective));
        cache.putEffectives(programItemId, effectives);
        return true;
    }

    private Integer _getNbPathes(String programItemId, CostComputationDataCache cache) {
        return Optional.of(programItemId).map(cache::getPathes).map(Set::size).orElse(1);
    }

    private Optional<Double> _computeLocalEffectiveFromParent(String currentPath, String parentProgramItemId, Supplier<Double> weightSupplier, CostComputationDataCache cache) {
        String parentPath = StringUtils.substringBeforeLast((String)currentPath, (String)"/");
        return Optional.ofNullable(parentProgramItemId).map(cache::getEffectives).map(eff -> eff.getLocalEffective(parentPath)).map(eff -> eff * (Double)weightSupplier.get());
    }

    private void _computeLocalEqTD(CoursePart coursePart, Course currentParentCourse, String currentPath, Container currentStep, CostComputationDataCache cache) {
        EqTD coursePartEqTD = cache.getEqTD(coursePart.getId());
        coursePartEqTD.addLocalEqTD4CoursePart(currentPath, this._isHeld(coursePart, currentParentCourse, currentStep));
        cache.putEqTD(coursePart.getId(), coursePartEqTD);
    }

    private Double _localEqTD(ProgramItem programItem, String currentPath, CostComputationDataCache cache) {
        Course course;
        Double localEqTDsum = 0.0;
        if (programItem instanceof Course && !(course = (Course)programItem).hasCourseLists()) {
            for (CoursePart coursePart : course.getCourseParts()) {
                EqTD coursePartEqTD = cache.getEqTD(coursePart.getId());
                localEqTDsum = localEqTDsum + coursePartEqTD.getLocalEqTD(currentPath + "/" + coursePart.getName());
            }
        } else {
            for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
                localEqTDsum = localEqTDsum + this._localEqTD(child, currentPath + "/" + child.getName(), cache);
            }
        }
        EqTD eqTD = cache.getEqTD(programItem.getId());
        eqTD.addLocalEqTD(currentPath, localEqTDsum);
        cache.putEqTD(programItem.getId(), eqTD);
        return localEqTDsum;
    }

    private boolean _isHeld(CoursePart coursePart, Course currentCourse, Container currentStep) {
        Course courseHolder = coursePart.getCourseHolder();
        if (courseHolder == null) {
            return true;
        }
        if (currentCourse.equals((Object)courseHolder)) {
            Container stepHolder = this._getStepHolder(courseHolder);
            return stepHolder == null || stepHolder.equals((Object)currentStep);
        }
        return false;
    }

    public CostComputationData computeCostsOnProgram(Program program, boolean needsAdditionalComputation) {
        return this.computeCostsOnProgram(program, needsAdditionalComputation, new OverriddenData(), true);
    }

    public CostComputationData computeCostsOnProgram(Program program, boolean needsAdditionalComputation, OverriddenData overriddenData, boolean checkEffectiveConsistency) {
        return this.computeCostsOnPrograms(List.of(program), needsAdditionalComputation, overriddenData, checkEffectiveConsistency);
    }

    private void _searchAndComputeCourseParts(ProgramItem programItem, CostComputationDataCache cache) {
        String programItemId = programItem.getId();
        if (cache.addExploredItem(programItemId)) {
            Course course;
            this._computePathes(programItem, cache);
            this._computeEffectives(programItem, cache);
            if (programItem instanceof Course && !(course = (Course)programItem).hasCourseLists()) {
                this._computeCourseParts(course, cache);
            } else {
                double weight = this._getWeight(programItem, cache);
                VolumesOfHours volumesOfHours = new VolumesOfHours();
                EqTD eqTD = new EqTD();
                List children = this._odfHelper.getChildProgramItems(programItem);
                for (ProgramItem child : children) {
                    this._searchAndComputeCourseParts(child, cache);
                    ProgramItemData childData = cache.getProgramItemData(child.getId());
                    if (childData == null) continue;
                    Optional.ofNullable(childData.getVolumesOfHours()).ifPresent(childVolumesOfHours -> volumesOfHours.sum((VolumesOfHours)childVolumesOfHours, weight));
                    Optional.ofNullable(childData.getEqTD()).ifPresent(childEqTD -> eqTD.sum((EqTD)childEqTD));
                }
                cache.putVolumesOfHours(programItemId, volumesOfHours);
                cache.putEqTD(programItemId, eqTD);
            }
        }
    }

    private Set<String> _computePathes(ProgramItem programItem, CostComputationDataCache cache) {
        Set<String> pathes = cache.getPathes(programItem.getId());
        if (pathes == null) {
            String programItemName = programItem.getName();
            pathes = programItem instanceof Program ? Set.of(programItemName) : this._odfHelper.getParentProgramItems(programItem).stream().map(parent -> this._computePathes((ProgramItem)parent, cache)).flatMap(Collection::stream).distinct().map(parentPath -> parentPath + "/" + programItemName).collect(Collectors.toSet());
            cache.putPathes(programItem.getId(), pathes);
        }
        return pathes;
    }

    private void _computeCourseParts(Course course, CostComputationDataCache cache) {
        VolumesOfHours volumesOfHours = new VolumesOfHours();
        EqTD eqTD = new EqTD();
        for (CoursePart coursePart : course.getCourseParts()) {
            this._computeCoursePart(coursePart, cache);
            String coursePartId = coursePart.getId();
            Optional.of(coursePartId).map(cache::getVolumesOfHours).ifPresent(childVolumesOfHours -> volumesOfHours.sum((VolumesOfHours)childVolumesOfHours, 1.0));
            Optional.of(coursePartId).map(cache::getEqTD).ifPresent(childEqTD -> eqTD.sum((EqTD)childEqTD));
        }
        String courseId = course.getId();
        cache.putVolumesOfHours(courseId, volumesOfHours);
        cache.putEqTD(courseId, eqTD);
    }

    private <T extends Content & ProgramItem> Container _getStepHolder(T programItem) {
        Pair<PilotageHelper.StepHolderStatus, Container> stepHolder = this._pilotageHelper.getStepHolder(programItem);
        switch ((PilotageHelper.StepHolderStatus)((Object)stepHolder.getKey())) {
            case NO_YEAR: {
                this.getLogger().warn("[{}][{}] Impossible de trouver une nature de conteneur 'annee'.", (Object)programItem.getTitle(), (Object)((ProgramItem)programItem).getDisplayCode());
                break;
            }
            case NONE: {
                this.getLogger().info("[{}][{}] Aucune ann\u00e9e n'est rattach\u00e9e \u00e0 l'ELP '{}' directement ou indirectement.", new Object[]{programItem.getTitle(), ((ProgramItem)programItem).getDisplayCode(), programItem.getTitle()});
                break;
            }
            case MULTIPLE: {
                this.getLogger().info("[{}][{}] Plusieurs ann\u00e9es sont rattach\u00e9es \u00e0 l'ELP '{}', impossible de d\u00e9terminer laquelle est porteuse.", new Object[]{programItem.getTitle(), ((ProgramItem)programItem).getDisplayCode(), programItem.getTitle()});
                break;
            }
            case WRONG_YEAR: {
                this.getLogger().info("[{}][{}] L'ann\u00e9e porteuse {} n'est pas dans l'arborescence de l'ELP '{}'.", new Object[]{programItem.getTitle(), ((ProgramItem)programItem).getDisplayCode(), ((Container)stepHolder.getValue()).getTitle(), programItem.getTitle()});
                break;
            }
        }
        return (Container)stepHolder.getValue();
    }

    private NormDetails _computeNormDetails(CoursePart coursePart, CostComputationDataCache cache) {
        String nature = coursePart.getNature();
        return this._getNorm((Content)coursePart, nature, cache).or(() -> this._getNorm((Content)this._getStepHolder(coursePart), nature, cache)).map(n -> cache.getNormDetailsForNature((String)n, nature)).orElseGet(() -> cache.getEffectiveMinMaxByNature(nature));
    }

    private Container _getStepHolder(CoursePart coursePart) {
        Course courseHolder = coursePart.getCourseHolder();
        if (courseHolder == null) {
            this.getLogger().warn("[{}][{}] L'ELP porteur est soit vide, soit invalide.", (Object)coursePart.getTitle(), (Object)coursePart.getCode());
        }
        return Optional.ofNullable(courseHolder).map(this::_getStepHolder).orElse(null);
    }

    private void _computeCoursePart(CoursePart coursePart, CostComputationDataCache cache) {
        String coursePartId = coursePart.getId();
        if (cache.addExploredItem(coursePartId)) {
            String coursePartNature = coursePart.getNature();
            cache.setIsCoursePart(coursePartId, true);
            VolumesOfHours volumesOfHours = new VolumesOfHours();
            volumesOfHours.addVolume(coursePartNature, coursePart.getNumberOfHours());
            Double overriddenVolumeOfHours = cache.getOverriddenVolumeOfHours(coursePartId);
            if (overriddenVolumeOfHours != null) {
                volumesOfHours.addOverriddenVolume(coursePartNature, overriddenVolumeOfHours);
            }
            cache.putVolumesOfHours(coursePartId, volumesOfHours);
            Effectives effectives = new Effectives();
            List parentCourses = coursePart.getCourses();
            effectives.setNbOccurrences(parentCourses.size());
            HashSet<String> pathes = new HashSet<String>();
            for (Course course : parentCourses) {
                String courseName = course.getName();
                effectives.add(this._computeEffectives((ProgramItem)course, cache), courseName);
                pathes.addAll(this._computePathes((ProgramItem)course, cache).stream().map(parentPath -> parentPath + "/" + courseName).collect(Collectors.toSet()));
            }
            cache.putEffectives(coursePartId, effectives);
            cache.putPathes(coursePartId, pathes);
            NormDetails normDetails = this._computeNormDetails(coursePart, cache);
            cache.putNormDetails(coursePartId, normDetails);
            if (normDetails == null) {
                this.getLogger().warn("[{}][{}] La nature d'enseignement est soit vide, soit invalide.", (Object)coursePart.getTitle(), (Object)coursePart.getCode());
                normDetails = new NormDetails(null, null);
            }
            Double globalEffectives = effectives.getEstimatedEffective().orElse(0.0);
            Long computedGroups = this._computeGroups(globalEffectives, normDetails);
            Groups groups = new Groups();
            groups.setOverriddenGroups(cache.getOverriddenGroups(coursePartId));
            groups.setGroupsToOpen((Long)coursePart.getValue("groupsToOpen"));
            groups.setComputedGroups(computedGroups);
            cache.putGroups(coursePartId, groups);
            ProgramItemData programItemData = cache.getProgramItemData(coursePartId);
            Double eqTDCoef = Optional.of(coursePart).map(cp -> (String)cp.getValue("eqTD")).map(PilotageHelper::transformEqTD2Double).orElseGet(() -> cache.getEqTDByNature(coursePartNature));
            String eqTDComputationModeId = Optional.ofNullable(coursePartNature).map(cache::getEqTDComputationByNature).orElse("org.ametys.plugins.odfpilotage.cost.eqtd.GroupsMode");
            EqTDComputationMode eqTDComputationMode = (EqTDComputationMode)this._eqTDComputationModeEP.getExtension(eqTDComputationModeId);
            Double globalEqTD = eqTDComputationMode.computeEqTD(programItemData, eqTDCoef);
            EqTD eqTD = new EqTD();
            eqTD.addGlobalEqTD(coursePartId, globalEqTD);
            cache.putEqTD(coursePartId, eqTD);
        }
    }

    private Effectives _computeEffectives(ProgramItem programItem, CostComputationDataCache cache) {
        String programItemId = programItem.getId();
        Effectives effectives = cache.getEffectives(programItemId);
        if (effectives == null) {
            effectives = new Effectives();
            List programItemParents = this._odfHelper.getParentProgramItems(programItem);
            if (!(programItem instanceof Program)) {
                effectives.setNbOccurrences(programItemParents.size());
            }
            Optional<Double> overriddenEffective = Optional.of(programItemId).map(cache::getOverriddenEffective).map(Long::doubleValue);
            effectives.setOverriddenEffective(overriddenEffective);
            Optional<Double> enteredEffective = Optional.of(programItem).filter(Predicate.not(CourseList.class::isInstance)).map(Content.class::cast).map(pi -> (Long)pi.getValue(__EFFECTIF_ESTIMATED)).map(Long::doubleValue);
            effectives.setEnteredEffective(enteredEffective);
            boolean isYear = this._odfHelper.isContainerOfNature(programItem, cache.getYearNature());
            Optional<Double> writtenEffective = overriddenEffective.or(() -> enteredEffective);
            if (writtenEffective.isPresent()) {
                Double eff = writtenEffective.get();
                effectives.addEstimatedEffective(programItem.getName(), eff);
                if (isYear) {
                    effectives.addComputedEffective(programItemId, eff);
                }
            } else if (isYear) {
                this.getLogger().warn("[{}][{}] Aucun effectif n'a \u00e9t\u00e9 saisi sur cette ann\u00e9e.", (Object)((Container)programItem).getTitle(), (Object)programItem.getCode());
            }
            for (ProgramItem parent : programItemParents) {
                effectives.add(this._computeEffectives(parent, cache), parent.getName());
            }
            cache.putEffectives(programItemId, effectives);
        }
        return effectives.cloneWithWeight(this._getWeight(programItem, cache));
    }

    private double _getWeight(ProgramItem programItem, CostComputationDataCache cache) {
        Double weight = cache.getWeight(programItem.getId());
        if (weight == null) {
            weight = 1.0;
            if (programItem instanceof CourseList) {
                CourseList courseList = (CourseList)programItem;
                CourseList.ChoiceType type = courseList.getType();
                switch (type) {
                    case OPTIONAL: {
                        weight = 0.0;
                        break;
                    }
                    case CHOICE: {
                        long min = courseList.getMinNumberOfCourses();
                        long max = courseList.getMaxNumberOfCourses();
                        long size = courseList.getCourses().size();
                        if (min != max) {
                            this.getLogger().warn("[{}][{}] La liste contient min={} et max={}. Retenu {}", new Object[]{courseList.getTitle(), courseList.getDisplayCode(), min, max, min});
                        }
                        if (min > size) {
                            this.getLogger().warn("[{}][{}] La liste contient min={} mais n'a que {} \u00e9l\u00e9ments.", new Object[]{courseList.getTitle(), courseList.getDisplayCode(), min, size});
                            break;
                        }
                        weight = (double)min / (double)size;
                        break;
                    }
                }
            }
            cache.putWeight(programItem.getId(), weight);
        }
        return weight;
    }

    private Long _computeGroups(Double effective, NormDetails normDetails) {
        long effectiveMax = normDetails.getEffectiveMaxOrDefault();
        long effectiveMinSup = normDetails.getEffectiveMinSupOrDefault();
        if (effective == 0.0) {
            return 0L;
        }
        if (effective < (double)effectiveMax) {
            return 1L;
        }
        Long groups = Math.round(effective) / effectiveMax;
        if (effective - (double)(groups * effectiveMax) >= (double)effectiveMinSup) {
            Long l = groups;
            groups = groups + 1L;
        }
        return groups;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<String> _getNorm(Content content, String nature, CostComputationDataCache cache) {
        if (content == null) {
            return Optional.empty();
        }
        String logName = content instanceof Container ? "ann\u00e9e porteuse" : "heure d'enseignement";
        ContentValue normValue = (ContentValue)content.getValue("norme");
        Optional<String> normIdOpt = Optional.ofNullable(normValue).map(ContentValue::getContentId).filter(StringUtils::isNotEmpty);
        if (normIdOpt.isPresent()) {
            String normId = normIdOpt.get();
            if (!cache.normExists(normId)) {
                this.getLogger().warn("[{}][{}] L'{} '{}' poss\u00e8de une norme invalide.", new Object[]{content.getTitle(), content.getValue("code"), logName, content.getTitle()});
                return Optional.empty();
            } else {
                if (cache.natureInNormExists(normId, nature)) return normIdOpt;
                if (!this.getLogger().isWarnEnabled()) return Optional.empty();
                ModifiableContent norm = normValue.getContent();
                this.getLogger().warn("[{}][{}] La norme '{}' n'est pas d\u00e9finie pour la nature d'enseignement {}.", new Object[]{content.getTitle(), content.getValue("code"), norm.getTitle(), this._refTableHelper.getItemCode(nature)});
            }
            return Optional.empty();
        } else {
            if (!this.getLogger().isInfoEnabled()) return Optional.empty();
            this.getLogger().info("[{}][{}] L'{} '{}' n'a pas de norme associ\u00e9e.", new Object[]{content.getTitle(), content.getValue("code"), logName, content.getTitle()});
        }
        return Optional.empty();
    }
}

