/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.List;
import java.util.Map;

import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.workflow.copy.CopyODFContentClientSideElement;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;

/**
 * Override button for odf content to take into account the attribute restrictions before copy
 */
public class CopyODFPilotageContentClientSideElement extends CopyODFContentClientSideElement
{
    @SuppressWarnings("unchecked")
    @Override
    protected boolean canCopyTo(Content copiedContent, Content targetContent, List<I18nizableText> errors, Map<String, Object> contextualParameters)
    {
        boolean canCopyTo = super.canCopyTo(copiedContent, targetContent, errors, contextualParameters);
        if (canCopyTo && copiedContent instanceof ProgramItem copiedProgramItem && targetContent instanceof ProgramItem parentProgramItem)
        {
            // Additional check on parent attributes' restrictions 
            String parentAttributeName = _odfHelper.getDescendantRelationAttributeName(parentProgramItem, copiedProgramItem);
            if (parentAttributeName != null)
            {
                ModelItem modelItem = ModelHelper.getModelItem(parentAttributeName, targetContent.getModel());
                if (modelItem instanceof RestrictedModelItem rModelItem && !rModelItem.canWrite(targetContent))
                {
                    errors.add(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CONTROLLER_COPY_STATUS_RESTRICTIONS_DISABLED_MSG", List.of(targetContent.getTitle())));
                    return false;
                }
            }
        }
        
        return canCopyTo;
    }
}
