/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.type.ModelItemTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PilotageHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = PilotageHelper.class.getName();
    public static final String MCC_MODALITE_SESSION1 = "odf-enumeration.MccModaliteSession1";
    public static final String MCC_MODALITE_SESSION2 = "odf-enumeration.MccModaliteSession2";
    public static final String MCC_SESSION_NATURE = "odf-enumeration.MccSessionNature";
    public static final String COMPATIBLE_REGIMES_ATTRIBUTE_NAME = "compatibleRegimes";
    public static final String NORME = "odf-enumeration.Norme";
    public static final String CONTAINER_MCC_REGIME = "mccRegime";
    public static final String CONTAINER_MCC_NUMBER_OF_SESSIONS = "mccNbSessions";
    public static final String COURSE_MCC_REGIME = "mccRegime";
    public static final String EXCLUDED_FROM_MCC = "excludedFromMCC";
    private static final String __STEP_HOLDERS_BY_ITEM_CACHE_ID = PilotageHelper.class.getName() + "$stepHoldersByItem";
    private static final String __STEPS_BY_ITEM_CACHE_ID = PilotageHelper.class.getName() + "$stepsByItem";
    private static final String __CONTENTS_BY_NAME_CACHE_ID = PilotageHelper.class.getName() + "$contentsByName";
    protected ODFHelper _odfHelper;
    protected AbstractCacheManager _cacheManager;
    protected AmetysObjectResolver _ametysResolver;
    protected RightManager _rightManager;
    private ModelItemTypeExtensionPoint _contentAttribute;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._ametysResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentAttribute = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_CONTENT_ATTRIBUTE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    public void initialize() throws Exception {
        if (!this._cacheManager.hasCache(__STEPS_BY_ITEM_CACHE_ID)) {
            this._cacheManager.createRequestCache(__STEPS_BY_ITEM_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_STEPS_BY_ITEM_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_STEPS_BY_ITEM_DESCRIPTION"), false);
        }
        if (!this._cacheManager.hasCache(this._getStepsHolderByItemCacheId())) {
            this._cacheManager.createRequestCache(this._getStepsHolderByItemCacheId(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_STEP_HOLDERS_BY_ITEM_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_STEP_HOLDERS_BY_ITEM_DESCRIPTION"), false);
        }
        if (!this._cacheManager.hasCache(__CONTENTS_BY_NAME_CACHE_ID)) {
            this._cacheManager.createRequestCache(__CONTENTS_BY_NAME_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTENTS_BY_NAME_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTENTS_BY_NAME_DESCRIPTION"), false);
        }
    }

    public void invalidateAllCaches() {
        this._cacheManager.get(this._getStepsHolderByItemCacheId()).invalidateAll();
        this._cacheManager.get(__STEPS_BY_ITEM_CACHE_ID).invalidateAll();
    }

    public Pair<StepHolderStatus, Container> getStepHolder(ProgramItem programItem) {
        Optional yearId = this._odfHelper.getYearId();
        if (yearId.isEmpty()) {
            return Pair.of((Object)((Object)StepHolderStatus.NO_YEAR), null);
        }
        Set<Container> stepsHolder = this._getStepsHolder(programItem, (String)yearId.get());
        switch (stepsHolder.size()) {
            case 0: {
                return Pair.of((Object)((Object)StepHolderStatus.NONE), null);
            }
            case 1: {
                Container stepHolder = (Container)stepsHolder.stream().findFirst().get();
                StepHolderStatus status = this.getSteps(programItem).contains(stepHolder) ? StepHolderStatus.SINGLE : StepHolderStatus.WRONG_YEAR;
                return Pair.of((Object)((Object)status), (Object)stepHolder);
            }
        }
        return Pair.of((Object)((Object)StepHolderStatus.MULTIPLE), null);
    }

    public Set<Container> getParentYears(ProgramItem programItem) {
        return this._odfHelper.getYearId().map(yearId -> this._getStepsHolder(programItem, (String)yearId)).orElseGet(() -> Set.of());
    }

    protected Set<Container> _getStepsHolder(ProgramItem programItem, String yearId) {
        Cache cache = this._cacheManager.get(this._getStepsHolderByItemCacheId());
        return (Set)cache.get((Object)programItem.getId(), __ -> this._getStepHolderFromCourse(programItem).or(() -> this._getStepHolderFromContainer(programItem, yearId)).map(Collections::singleton).orElseGet(() -> this._getStepsHolderFromParentElements(programItem, yearId)));
    }

    private Optional<Container> _getStepHolderFromCourse(ProgramItem programItem) {
        return Optional.of(programItem).filter(Course.class::isInstance).map(Course.class::cast).map(c -> (ContentValue)c.getValue("etapePorteuse")).flatMap(ContentValue::getContentIfExists).map(Container.class::cast);
    }

    private Optional<Container> _getStepHolderFromContainer(ProgramItem programItem, String yearId) {
        return Optional.of(programItem).filter(pi -> this._odfHelper.isContainerOfNature(pi, yearId)).map(Container.class::cast);
    }

    @Deprecated
    public boolean isContainerOfNature(ProgramItem programItem, String natureId) {
        return this._odfHelper.isContainerOfNature(programItem, natureId);
    }

    private Set<Container> _getStepsHolderFromParentElements(ProgramItem programItem, String yearId) {
        return this._odfHelper.getParentProgramItems(programItem).stream().map(pi -> this._getStepsHolder((ProgramItem)pi, yearId)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Container> getSteps(ProgramItem programItem) {
        return this._odfHelper.getYearId().map(yearId -> this._getSteps(programItem, (String)yearId)).orElseGet(() -> Set.of());
    }

    protected Set<Container> _getSteps(ProgramItem programItem, String yearId) {
        Cache cache = this._cacheManager.get(__STEPS_BY_ITEM_CACHE_ID);
        return (Set)cache.get((Object)programItem.getId(), __ -> this._getStepsToCache(programItem, yearId));
    }

    protected Set<Container> _getStepsToCache(ProgramItem programItem, String yearId) {
        HashSet<Container> containers = new HashSet<Container>();
        if (this._odfHelper.isContainerOfNature(programItem, yearId)) {
            containers.add((Container)programItem);
        } else {
            for (ProgramItem parent : this._odfHelper.getParentProgramItems(programItem)) {
                containers.addAll(this._getSteps(parent, yearId));
            }
        }
        return containers;
    }

    @Deprecated
    public boolean isContainerOfTypeYear(Content content) {
        return this._odfHelper.isContainerOfTypeYear(content);
    }

    @Callable(rights={"*"})
    @Deprecated
    public boolean isContainerOfTypeYear(String containerId) {
        return this._odfHelper.isContainerOfTypeYear(containerId);
    }

    @Deprecated
    public boolean isContainerOfTypeYear(Container container) {
        return this._odfHelper.isContainerOfTypeYear(container);
    }

    @Deprecated
    public synchronized Optional<String> getYearId() {
        return this._odfHelper.getYearId();
    }

    public static Double transformEqTD2Double(String eqTD) {
        Double eqTDDouble = null;
        if (StringUtils.isNotEmpty((CharSequence)eqTD)) {
            if (eqTD.indexOf(47) != -1) {
                Double numerator = Double.valueOf(eqTD.substring(0, eqTD.indexOf(47)));
                Double denominator = Double.valueOf(eqTD.substring(eqTD.indexOf(47) + 1));
                eqTDDouble = numerator / denominator;
            } else {
                eqTDDouble = Double.valueOf(eqTD);
            }
        }
        return eqTDDouble;
    }

    public String getDisplayablePath(String path) {
        return this.getContentsFromPath(path).map(Content::getTitle).collect(Collectors.joining(" > "));
    }

    public Stream<Content> getContentsFromPath(String path) {
        return ((Stream)Stream.of(path.split("/")).sequential()).filter(StringUtils::isNotEmpty).map(this::getContentFromName).flatMap(Optional::stream);
    }

    public Optional<Content> getContentFromName(String name) {
        Cache cache = this._cacheManager.get(__CONTENTS_BY_NAME_CACHE_ID);
        return (Optional)cache.get((Object)name, __ -> this._ametysResolver.query(QueryHelper.getXPathQuery((String)name, (String)"ametys:content", null)).stream().findFirst());
    }

    @Callable(rights={"__READ_ACCESS"}, rightContext="right.assignment.context.content", paramIndex=0)
    public List<String> getCompatibleRegimes(String contentId) {
        Content content = (Content)this._ametysResolver.resolveById(contentId);
        if (content.hasValue(COMPATIBLE_REGIMES_ATTRIBUTE_NAME)) {
            ContentValue[] contentValues = (ContentValue[])content.getValue(COMPATIBLE_REGIMES_ATTRIBUTE_NAME);
            return Arrays.stream(contentValues).map(ContentValue::getContentId).toList();
        }
        return List.of();
    }

    protected String _getStepsHolderByItemCacheId() {
        return __STEP_HOLDERS_BY_ITEM_CACHE_ID;
    }

    @Callable(rights={"*"})
    public Map<String, Map<String, Object>> getCompatibleModalityInSession2(List<String> contentIds) {
        return contentIds.stream().map(this::_findCorrespondingModality).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private Pair<String, Map<String, Object>> _findCorrespondingModality(String modality1) {
        String code;
        Map matching = null;
        Content content = (Content)this._ametysResolver.resolveById(modality1);
        if (content.hasValue("code") && StringUtils.isNotBlank((CharSequence)(code = (String)content.getValue("code")))) {
            ContentTypeExpression ctypeExp = new ContentTypeExpression(Expression.Operator.EQ, new String[]{MCC_MODALITE_SESSION2});
            StringExpression sExpr = new StringExpression("code", Expression.Operator.EQ, code);
            NotExpression notArchivedExpr = new NotExpression((Expression)new BooleanExpression("archived", true));
            AmetysObjectIterable answers = this._ametysResolver.query("//element(*, ametys:content)[" + new AndExpression(new Expression[]{ctypeExp, sExpr, notArchivedExpr}).build() + "]");
            if (answers.getSize() != 1L) {
                this.getLogger().error("Cannot find a matching code to " + code + " in odf-enumeration.MccModaliteSession2");
            } else {
                Content matchingContent = (Content)answers.iterator().next();
                if (matchingContent.hasValue("code")) {
                    matching = (Map)((ModelItemType)this._contentAttribute.getExtension("content")).valueToJSONForClient((Object)matchingContent, DataContext.newInstance());
                }
            }
        }
        if (matching == null) {
            matching = new HashMap();
        }
        return Pair.of((Object)modality1, matching);
    }

    public boolean canWriteMccRestrictions(Content content, String attributePath) {
        if (content != null && content instanceof Course) {
            Course course = (Course)content;
            if (attributePath.equals("mccRegime") && this.getMCCRegimePolicy().equals("FORCE")) {
                return this.getValueFromSteps(course, "mccRegime").map(ContentValue::getContentIfExists).map(Optional::isEmpty).orElse(true);
            }
        }
        return true;
    }

    public <T> Optional<T> getValueFromSteps(Course course, String attributeName) {
        return this._getValueFromStepHolder(course, attributeName).or(() -> this._getCommonValueFromSteps(course, attributeName));
    }

    private <T> Optional<T> _getValueFromStepHolder(Course course, String attributeName) {
        return Optional.of(this.getStepHolder((ProgramItem)course)).filter(p -> p.getLeft() == StepHolderStatus.SINGLE).map(p -> (Container)p.getRight()).map(c -> c.getValue(attributeName));
    }

    private <T> Optional<T> _getCommonValueFromSteps(Course course, String attributeName) {
        List<Object> potentialValues = this.getSteps((ProgramItem)course).stream().map(c -> c.getValue(attributeName)).distinct().toList();
        if (potentialValues.size() > 1) {
            return Optional.empty();
        }
        return potentialValues.stream().filter(Objects::nonNull).findFirst();
    }

    public String getMCCRegimePolicy() {
        return (String)Config.getInstance().getValue("odf.mcc.restrictions.policy.regime", true, (Object)"INFO");
    }

    public String getMCCNbSessionsPolicy() {
        return (String)Config.getInstance().getValue("odf.mcc.restrictions.policy.nbSessions", true, (Object)"INFO");
    }

    @Callable(rights={"*"})
    public Map<String, Object> getMCCConfiguration() {
        return Map.of("rulesEnabled", true, "regimeForced", this.getMCCRegimePolicy().equals("FORCE"), "nbSessionBlocked", this.getMCCNbSessionsPolicy().equals("BLOCK"));
    }

    @Deprecated
    public Set<Container> getYears(TraversableProgramPart programPart) {
        return this._odfHelper.getYears(programPart);
    }

    @Callable(rights={""})
    public Map<String, Object> setExcludedMCCState(List<String> courseIds, boolean isExcluded) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map<String, String>> noRightCourses = new ArrayList<Map<String, String>>();
        ArrayList<String> alrightCourseIds = new ArrayList<String>();
        for (String id : courseIds) {
            Course course = (Course)this._ametysResolver.resolveById(id);
            if (this._rightManager.currentUserHasRight("ODF_Rights_Pilotage_Exclude_From_MCC", (Object)course) == RightManager.RightResult.RIGHT_ALLOW) {
                this.excludeFromMCC(course, isExcluded);
                course.saveChanges();
                alrightCourseIds.add(id);
                continue;
            }
            noRightCourses.add(Map.of("id", id, "title", course.getTitle()));
        }
        result.put("alrightCourseIds", alrightCourseIds);
        result.put("noRightCourses", noRightCourses);
        return result;
    }

    public boolean isExcludedFromMCC(Course course) {
        return (Boolean)course.getInternalDataHolder().getValue(EXCLUDED_FROM_MCC, (Object)false);
    }

    public void excludeFromMCC(Course course, boolean isExcluded) {
        course.getInternalDataHolder().setValue(EXCLUDED_FROM_MCC, (Object)isExcluded);
    }

    public boolean isParentExcludedInMCC(ProgramItem programItem) {
        if (programItem instanceof Course) {
            Course course = (Course)programItem;
            List parentCourseLists = course.getParentCourseLists();
            return !parentCourseLists.isEmpty() && parentCourseLists.stream().allMatch(this::isParentExcludedInMCC);
        }
        if (programItem instanceof CourseList) {
            CourseList courseList = (CourseList)programItem;
            List parentCourses = courseList.getParentCourses();
            return !parentCourses.isEmpty() && parentCourses.stream().allMatch(c -> this.isExcludedFromMCC((Course)c) || this.isParentExcludedInMCC((ProgramItem)c));
        }
        return false;
    }

    public static enum StepHolderStatus {
        NONE,
        SINGLE,
        MULTIPLE,
        NO_YEAR,
        WRONG_YEAR;

    }
}

