  /*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const ametysIdentifier = Ametys.serviceManager.lookup(org.ametys.cms.helper.AmetysIdentifiers.ROLE);
    
migrateIdentifier(Repository.session);
migrateIdentifier(Repository.liveSession);

function migrateIdentifier(s)
{
    let root = Repository.resolver.resolveByPath("ametys:plugins", s);
    if (root.hasChild("_identifier"))
    {
        let identifier = root.getChild("_identifier").getNode();
        if (identifier.hasProperty("TS"))
        {
           let counter = identifier.getProperty("TS").getLong();
           ametysIdentifier.saveCounter("odf-pilotage", "TS", counter);
           logger.info(`Moving attribute thematic counter (TS:${counter}) to node ametys:plugins/ametys-internal:identifiers/odf-pilotage in ${s.getWorkspace().getName()} session`);  
        }
      
        identifier.remove();
        s.save();
    }
}