<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"> 
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/doc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    
    <xsl:template name="css-styles">
        body 
        {
            font-size: 10pt;
        }
        
        h1
        {
            font-size: 20pt;
            text-align: center;
        }
        
        h2
        {
            font-size: 16pt;
            text-align: center;
        }
        
        table
        {
            width: 100%;
            padding: 0px;
            margin: 0px;
            border-spacing: 0;
            border-collapse: collapse;
        }
        
        td
        {
            padding: 2pt;
        }
        
        thead tr td
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: darkblue;
            border: 0.5pt white solid;
            color: white;
        }
    </xsl:template>
    
    <xsl:template name="doc-title">
        <xsl:value-of select="programItem/@title"/>
    </xsl:template>
    
    <xsl:template name="body">
        <xsl:apply-templates select="programItem"/>
    </xsl:template>
    
    <xsl:template match="programItem">
        <h1><xsl:value-of select="@title"/></h1>
        
        <xsl:apply-templates select="analysis"/>
    </xsl:template>
    
    <xsl:template match="analysis">
        <h2><xsl:value-of select="title"/></h2>
        
        <xsl:if test="intro != ''">
            <p><xsl:value-of select="intro"/></p>
        </xsl:if>
        
        <xsl:choose>
            <xsl:when test="count(lines/line) > 0"><xsl:call-template name="line-table"/></xsl:when>
            <xsl:otherwise><p><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_CONSISTENCY_XSL_NO_ERROR"/></p></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="line-table">
        <table>
            <thead>
                <tr>
                    <xsl:for-each select="columns/column">
                        <td><xsl:value-of select="."/></td>
                    </xsl:for-each>
                </tr>
            </thead>
            <tbody>
                <xsl:for-each select="lines/line">
                    <tr>
                        <xsl:variable name="currentLine" select="."/>
                        <xsl:for-each select="ancestor::analysis/columns/column">
                            <xsl:variable name="columnName" select="@name"/>
                            <td>
                                <xsl:if test="@indentable = 'true'">
	                                <xsl:call-template name="indent-line-value">
						                <xsl:with-param name="indentationLevel"><xsl:value-of select="$currentLine/indentationLevel"/></xsl:with-param>
						            </xsl:call-template>
					            </xsl:if>
                                <xsl:call-template name="display-line-value">
                                    <xsl:with-param name="lineValue"><xsl:value-of select="$currentLine/*[local-name() = $columnName]"/></xsl:with-param>
                                </xsl:call-template>
                            </td>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>
    
    <xsl:template name="indent-line-value">
        <xsl:param name="indentationLevel" select="'0'" />

        <xsl:if test="$indentationLevel &gt; 0">
            <!-- Add an unbreakable tab for each level -->
            <xsl:text>&#8195;</xsl:text>
            <xsl:call-template name="indent-line-value">
                <xsl:with-param name="indentationLevel" select="$indentationLevel - 1" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="display-line-value">
        <xsl:param name="lineValue" />
        
        <!-- Call the display-double template for each value, even string ones.
            The display-double template parse the value and format it if it is a number. So text values won't be modified.
            If some number values should not be formatted, this XSL and this template can be overridden -->
        <xsl:call-template name="display-double">
            <xsl:with-param name="value"><xsl:value-of select="$lineValue" /></xsl:with-param>
            <xsl:with-param name="showZero" select="true()"/>
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>
