/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This script migrates the config files for Apogée import
 * (add course part SCC if it doesn't exist and if the course SCC exists)
 */

const _sccHelper = Ametys.serviceManager.lookup(org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper.ROLE);
const COURSE_PART_SCC_MODEL_ID = org.ametys.plugins.odfsync.apogee.scc.impl.CoursePartSynchronizableContentsCollection.MODEL_ID;

let courseSCC = _sccHelper.getSCCFromModelId(org.ametys.plugins.odfsync.apogee.scc.impl.CourseSynchronizableContentsCollection.MODEL_ID);
if (courseSCC != null && _sccHelper.getSCCFromModelId(COURSE_PART_SCC_MODEL_ID) == null)
{
    logger.info("An Apogée courses SCC exists but not the Apogée course parts SCC, we create it.");
    
    const _sccDAO = Ametys.serviceManager.lookup(org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO.ROLE);
    const PARAM_DATASOURCE_ID = org.ametys.plugins.odfsync.apogee.scc.AbstractApogeeSynchronizableContentsCollection.PARAM_DATASOURCE_ID;
    const PARAM_YEAR = org.ametys.plugins.odfsync.apogee.scc.AbstractApogeeSynchronizableContentsCollection.PARAM_YEAR;
    const SCC_PARAMETERS_SEPARATOR = org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO.SCC_PARAMETERS_SEPARATOR;
    
    let sccParameters = new java.util.HashMap();
    sccParameters.put("label", "Apogée - heures d'enseignement");
    sccParameters.put("contentType", org.ametys.odf.coursepart.CoursePartFactory.COURSE_PART_CONTENT_TYPE);
    sccParameters.put("contentPrefix", "coursepart-");
    sccParameters.put("synchronizeExistingContentsOnly", courseSCC.synchronizeExistingContentsOnly());
    sccParameters.put("removalSync", courseSCC.removalSync());
    sccParameters.put("ignoreRestrictions", courseSCC.ignoreRestrictions());
    sccParameters.put("checkCollection", courseSCC.checkCollection());
    sccParameters.put("workflowName", "course-part");
    sccParameters.put("initialActionId", 1);
    sccParameters.put("synchronizeActionId", 800);
    sccParameters.put("validateActionId", 4);
    sccParameters.put("validateAfterImport", courseSCC.validateAfterImport());
    sccParameters.put("reportMails", courseSCC.getReportMails());
    sccParameters.put("contentOperator", "org.ametys.plugins.odfsync.apogee.scc.operator.ApogeeSynchronizingContentOperator");
    sccParameters.put("languages", courseSCC.getLanguages());
    sccParameters.put("modelId", COURSE_PART_SCC_MODEL_ID);
    sccParameters.put(COURSE_PART_SCC_MODEL_ID + SCC_PARAMETERS_SEPARATOR + PARAM_DATASOURCE_ID, courseSCC.getParameterValues().get(PARAM_DATASOURCE_ID));
    sccParameters.put(COURSE_PART_SCC_MODEL_ID + SCC_PARAMETERS_SEPARATOR + PARAM_YEAR, courseSCC.getParameterValues().get(PARAM_YEAR));
    
    let coursePartSCCId = _sccDAO.addCollection(sccParameters);
    logger.info(`Apogée course part SCC created with the name ${coursePartSCCId}`);
}
