/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.scc;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.odfsync.apogee.scc.AbstractApogeeSynchronizableContentsCollection;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ApogeeSynchronizableContentsCollectionHelper
implements Serviceable,
Component,
Contextualizable,
Initializable {
    public static final String ROLE = ApogeeSynchronizableContentsCollectionHelper.class.getName();
    public static final String HANDLED_CONTENTS = AbstractApogeeSynchronizableContentsCollection.class.getName() + "$handledContents";
    public static final String CATALOG = AbstractApogeeSynchronizableContentsCollection.class.getName() + "$catalog";
    public static final String LANG = AbstractApogeeSynchronizableContentsCollection.class.getName() + "$lang";
    protected SynchronizableContentsCollectionHelper _sccHelper;
    protected ODFHelper _odfHelper;
    protected SynchronizableContentsCollectionDAO _sccDAO;
    protected ContentDAO _contentDAO;
    protected CatalogsManager _catalogsManager;
    protected Context _context;
    protected String _odfLang;

    public void service(ServiceManager smanager) throws ServiceException {
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)smanager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._sccDAO = (SynchronizableContentsCollectionDAO)smanager.lookup(SynchronizableContentsCollectionDAO.ROLE);
        this._contentDAO = (ContentDAO)smanager.lookup(ContentDAO.ROLE);
        this._catalogsManager = (CatalogsManager)smanager.lookup(CatalogsManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void initialize() throws Exception {
        this._odfLang = (String)Config.getInstance().getValue("odf.programs.lang");
    }

    public void synchronizeContent(ModifiableContent content, Logger logger) {
        boolean handled = false;
        AbstractApogeeSynchronizableContentsCollection scc = this.getContentSCC((Content)content, logger).orElse(null);
        if (scc != null) {
            try {
                HashMap<String, Object> searchParams = new HashMap<String, Object>();
                String idField = scc.getIdField();
                String syncCode = (String)content.getValue(idField);
                if (StringUtils.isNotBlank((CharSequence)syncCode)) {
                    searchParams.put(idField, syncCode);
                    if (scc.removalSync() && scc.getTotalCount(searchParams, logger) == 0) {
                        this._contentDAO.forceDeleteContentsWithLog(List.of(content), null, logger);
                    } else {
                        scc.synchronizeContent(content, logger);
                    }
                    handled = true;
                } else {
                    logger.warn("The synchronization code of the content '{}' ({}) is empty but it has the SCC '{}'. It has been skipped.", new Object[]{content.getTitle(), content.getId(), scc.getId()});
                }
            }
            catch (Exception e) {
                logger.error("An error occurred synchronized content '{}' ({}) from SCC '{}'", new Object[]{content.getTitle(), content.getId(), scc.getId(), e});
            }
        }
        if (!handled && this.addToHandleContents(content.getId()) && content instanceof ProgramItem) {
            ProgramItem programItem = (ProgramItem)content;
            for (ProgramItem syncChild : this._odfHelper.getChildProgramItems(programItem)) {
                this.synchronizeContent((ModifiableContent)syncChild, logger);
            }
            if (content instanceof Course) {
                Course course = (Course)content;
                for (CoursePart syncChild : course.getCourseParts()) {
                    this.synchronizeContent((ModifiableContent)syncChild, logger);
                }
            }
        }
    }

    public Optional<AbstractApogeeSynchronizableContentsCollection> getContentSCC(Content content, Logger logger) {
        try {
            return this._sccHelper.getSynchronizableCollectionIds(content).stream().map(arg_0 -> ((SynchronizableContentsCollectionDAO)this._sccDAO).getSynchronizableContentsCollection(arg_0)).filter(AbstractApogeeSynchronizableContentsCollection.class::isInstance).map(AbstractApogeeSynchronizableContentsCollection.class::cast).findFirst();
        }
        catch (Exception e) {
            logger.error("An error occurred getting ametys-internal:scc property", (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean addToHandleContents(String contentId) {
        return this._addContentToRequestAttribute(contentId, HANDLED_CONTENTS);
    }

    private boolean _addContentToRequestAttribute(String contentId, String attributeName) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Set handleContents = (Set)request.getAttribute(attributeName);
        boolean added = handleContents.add(contentId);
        request.setAttribute(attributeName, (Object)handleContents);
        return added;
    }

    public String getSynchronizationCatalog() {
        return Optional.of(ContextHelper.getRequest((Context)this._context)).map(r -> (String)r.getAttribute(CATALOG)).orElseGet(() -> this._catalogsManager.getDefaultCatalogName());
    }

    public String getSynchronizationLang() {
        return Optional.of(ContextHelper.getRequest((Context)this._context)).map(r -> (String)r.getAttribute(LANG)).orElse(this._odfLang);
    }
}

