/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.scc.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.cms.repository.Content;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfsync.apogee.scc.AbstractPreviousYearsSynchronizableContentsCollection;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class ContainerNbStudentsSynchronizableContentsCollection
extends AbstractPreviousYearsSynchronizableContentsCollection {
    protected OdfReferenceTableHelper _odfRefTableHelper;
    private Optional<String> _yearId = Optional.empty();

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._odfRefTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public String getIdField() {
        return "code";
    }

    @Override
    protected String getCurrentYearAttributeName() {
        return "numberOfStudentsCurrentYear";
    }

    @Override
    protected String getPrecedingYearAttributeName() {
        return "numberOfStudentsPrecedingYear";
    }

    @Override
    protected Stream<Content> getContents() {
        return super.getContents().filter(container -> this.isContainerOfTypeYear((Container)container));
    }

    @Override
    protected String getSyncCodeItemName() {
        return "apogeeSyncCodeNbStudents";
    }

    @Override
    protected List<Map<String, Object>> executeApogeeRequest(Map<String, Object> parameters) {
        return this._apogeePreviousYearsFieldsDAO.getYearNbStudents(this.getDataSourceId(), this.getParameterValues(), parameters);
    }

    @Deprecated
    private boolean isContainerOfTypeYear(Container container) {
        return this.getYearId().map(id -> StringUtils.equals((CharSequence)id, (CharSequence)container.getNature())).orElse(false);
    }

    @Deprecated
    private synchronized Optional<String> getYearId() {
        if (this._yearId.isEmpty()) {
            this._yearId = Optional.of(this._odfRefTableHelper).map(rth -> rth.getItemFromCode("odf-enumeration.ContainerNature", "annee")).map(OdfReferenceTableEntry::getId).filter(StringUtils::isNotBlank);
        }
        return this._yearId;
    }
}

