/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.scc.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.course.Course;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.odfsync.apogee.scc.AbstractApogeeSynchronizableContentsWithCatalogCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class CoursePartSynchronizableContentsCollection
extends AbstractApogeeSynchronizableContentsWithCatalogCollection {
    public static final String MODEL_ID = "org.ametys.plugins.odfsync.apogee.scc.coursepart";

    @Override
    protected List<Map<String, Object>> _search(Map<String, Object> searchParameters, Logger logger) {
        return this._convertBigDecimal(this._apogeeDAO.searchCourseParts(this.getDataSourceId(), this.getParameterValues(), searchParameters));
    }

    @Override
    protected String getMappingName() {
        return "coursepart";
    }

    @Override
    protected String getChildrenAttributeName() {
        return null;
    }

    @Override
    protected Pair<String, Object> getParentAttribute(ModifiableContent parent) {
        if (parent instanceof Course) {
            return Pair.of((Object)"courses", (Object)new ModifiableContent[]{parent});
        }
        return super.getParentAttribute(parent);
    }

    protected Map<String, Map<String, List<Object>>> getTransformedRemoteValues(Map<String, Object> searchParameters, Logger logger) {
        Map remoteValuesByContent = super.getTransformedRemoteValues(searchParameters, logger);
        SynchronizableContentsCollection courseSCC = this._sccHelper.getSCCFromModelId("org.ametys.plugins.odfsync.apogee.scc.course");
        String lang = this._apogeeSCCHelper.getSynchronizationLang();
        remoteValuesByContent.values().stream().forEach(remoteValues -> this._transformCourseHolder((Map<String, List<Object>>)remoteValues, courseSCC, lang));
        return remoteValuesByContent;
    }

    private void _transformCourseHolder(Map<String, List<Object>> remoteValues, SynchronizableContentsCollection courseSCC, String lang) {
        Optional.ofNullable(remoteValues.get("courseHolder")).map(Collection::stream).orElseGet(() -> Stream.of(new Object[0])).map(String.class::cast).filter(StringUtils::isNotBlank).map(courseHolderSyncCode -> courseSCC.getContent(lang, courseHolderSyncCode, false)).filter(Objects::nonNull).findFirst().map(AmetysObject::getId).ifPresentOrElse(courseHolderId -> remoteValues.put("courseHolder", List.of(courseHolderId)), () -> remoteValues.remove("courseHolder"));
    }
}

