/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.ws.structure;

import gouv.education.apogee.commun.client.ws.creationse.CreationSEMetierServiceInterface;
import java.rmi.RemoteException;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.StringUtils;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfsync.apogee.ws.structure.AbstractApogeeStructure;
import org.ametys.plugins.odfsync.export.ExportReport;

public class ApogeeDefaultStructure
extends AbstractApogeeStructure {
    @Override
    public void checkProgram(Program program, ExportReport report) {
        this.checkMandatoryDataForContent((Content)program, this.getDIPMandatoryData((Content)program), report);
        this.checkMandatoryDataForContent((Content)program, this.getVDIMandatoryData((Content)program), report);
        this.checkMandatoryDataForOrgunits((Content)program, program.getOrgUnits(), this.getOrgUnitMandatoryDataForDIP(), report);
        List programPartChildren = program.getProgramPartChildren();
        for (ProgramPart programPart : programPartChildren) {
            if (programPart instanceof SubProgram) {
                this.checkSubProgram((SubProgram)programPart, report);
                continue;
            }
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
            break;
        }
        if (programPartChildren.isEmpty()) {
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
        }
    }

    @Override
    public void checkSubProgram(SubProgram subProgram, ExportReport report) {
        this.checkMandatoryDataForContent((Content)subProgram, this.getETPMandatoryData((Content)subProgram), report);
        this.checkMandatoryDataForContent((Content)subProgram, this.getVETMandatoryData((Content)subProgram), report);
        this.checkMandatoryDataForOrgunits((Content)subProgram, subProgram.getOrgUnits(), this.getOrgUnitMandatoryDataForETP(), report);
        List programPartChildren = subProgram.getProgramPartChildren();
        for (ProgramPart childProgramPart : programPartChildren) {
            if (childProgramPart instanceof Container) {
                Container containerChildProgramPart = (Container)childProgramPart;
                String childContainerNatureCode = this.getContainerNatureCode(containerChildProgramPart);
                this.checkContainerAsSemester(containerChildProgramPart, report, childContainerNatureCode);
                continue;
            }
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
            break;
        }
        if (programPartChildren.isEmpty()) {
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
        }
    }

    @Override
    public void checkContainerAsYear(Container container, ExportReport report, String containerNatureCode) {
        throw new UnsupportedOperationException("No year container in this structure");
    }

    @Override
    public void createProgram(Program program, ExportReport report) {
        try {
            CreationSEMetierServiceInterface creationService = this._apogeeWS.getCreationService();
            String codDIP = this.getCodeApogee((Content)program);
            Long versionDIP = this.getVersionApogee((Content)program);
            this._apogeeWS.createDIP((Content)program, null, codDIP, creationService);
            this._apogeeWS.createVDI((Content)program, null, codDIP, versionDIP, creationService);
            for (ProgramPart pp : program.getProgramPartChildren()) {
                this._createSubProgram((SubProgram)pp, (Content)program, creationService, report);
            }
        }
        catch (Exception e) {
            report.setStatus(ExportReport.ExportStatus.ERROR);
            this.getLogger().error("An error occurred exporting the program '{}' ({}) in Apogee", new Object[]{program.getTitle(), program.getId(), e});
        }
    }

    protected void _createSubProgram(SubProgram subProgram, Content programParent, CreationSEMetierServiceInterface creationService, ExportReport report) throws RemoteException {
        String codDIP = this.getCodeApogee(programParent);
        Long versionDIP = this.getVersionApogee(programParent);
        String codETP = this.getCodeApogee((Content)subProgram);
        Long versionETP = this.getVersionApogee((Content)subProgram);
        this._apogeeWS.createETP((Content)subProgram, null, codETP, creationService);
        this._apogeeWS.createVET((Content)subProgram, null, codETP, versionETP, creationService);
        this._apogeeWS.createLinkDIPETP(codDIP, versionDIP, codETP, versionETP, creationService);
        for (ProgramPart pp : subProgram.getProgramPartChildren()) {
            this._createContainerAsELP((Container)pp, programParent, (Content)subProgram, creationService, report);
        }
    }

    protected void _createContainerAsELP(Container container, Content programParent, Content parentSubProgram, CreationSEMetierServiceInterface creationService, ExportReport report) throws RemoteException {
        String codETP = this.getCodeApogee(parentSubProgram);
        Long versionETP = this.getVersionApogee(parentSubProgram);
        String codELP = this.getCodeApogee((Content)container);
        this._apogeeWS.createELP((Content)container, null, codELP, creationService);
        String codLSE = StringUtils.generateKey();
        this._apogeeWS.createMandatoryLSE("LSE - " + parentSubProgram.getTitle(), codLSE, codELP, creationService);
        this._apogeeWS.createLinkETPELPLSE(codETP, versionETP, codLSE, null, null, null, null, creationService);
        for (ProgramPart pp : container.getProgramPartChildren()) {
            this._createCourseList((CourseList)pp, (Content)container, creationService, report);
        }
    }
}

