/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.actions;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.AvalonLoggerAdapter;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.core.user.UserDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpRequest;
import org.slf4j.Logger;

public class UploadCDMFrAction
extends ServiceableAction {
    public static final String REMOTE_CDMFR_SCC_MODEL_ID = "org.ametys.plugins.odfsync.remote.cdmfr.scc";
    public static final String CDMFR_IMPUT_STREAM_KEY_NAME = "cdmfr-input-stream";
    protected SynchronizableContentsCollectionHelper _sccHelper;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._sccHelper = (SynchronizableContentsCollectionHelper)sManager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)sManager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (request instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)request;
            SynchronizableContentsCollection scc = this._sccHelper.getSCCFromModelId(REMOTE_CDMFR_SCC_MODEL_ID);
            if (scc == null) {
                String message = "Can't find synchronizable contents collections for the remote CDMFr import with model id org.ametys.plugins.odfsync.remote.cdmfr.scc";
                this.getLogger().error(message);
                throw new IllegalStateException(message);
            }
            try (ServletInputStream is = httpRequest.getInputStream();){
                UserIdentity user = this._currentUserProvider.getUser();
                if (user == null) {
                    AuthenticateAction.setUserIdentityInSession((Request)request, (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY, (CredentialProvider)new UserDAO.ImpersonateCredentialProvider(), (boolean)true);
                }
                this.getLogger().info("Start of upload CDM-FR file");
                HashMap<String, ServletInputStream> importParams = new HashMap<String, ServletInputStream>();
                importParams.put(CDMFR_IMPUT_STREAM_KEY_NAME, is);
                scc.importContent(null, importParams, (Logger)new AvalonLoggerAdapter(this.getLogger()));
                this.getLogger().info("End of upload CDM-FR file");
            }
        }
        return EMPTY_MAP;
    }
}

