/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.extractor;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfsync.cdmfr.ImportCDMFrContext;
import org.ametys.plugins.odfsync.cdmfr.components.ImportCDMFrComponent;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCDMFrValuesExtractor;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCourseListValuesExtractor;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCoursePartValuesExtractor;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportCourseValuesExtractor;
import org.ametys.plugins.odfsync.cdmfr.extractor.ImportTraversableProgramPartValuesExtractor;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.extractor.ModelAwareValuesExtractor;
import org.ametys.runtime.model.Model;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.w3c.dom.Element;

public class ImportCDMFrValuesExtractorFactory
implements Component,
Serviceable {
    public static final String ROLE = ImportCDMFrValuesExtractorFactory.class.getName();
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    private OdfReferenceTableHelper _odfRefTableHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._odfRefTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public ModelAwareValuesExtractor getValuesExtractor(Element contentElement, ImportCDMFrComponent component, Content content, ContentType contentType, String syncCode, ImportCDMFrContext context) {
        if (content instanceof TraversableProgramPart) {
            return new ImportTraversableProgramPartValuesExtractor(contentElement, this, component, syncCode, context, new Model[]{contentType});
        }
        if (content instanceof CourseList) {
            return new ImportCourseListValuesExtractor(contentElement, this, component, context, new Model[]{contentType});
        }
        if (content instanceof Course) {
            return new ImportCourseValuesExtractor(contentElement, this, component, syncCode, context, new Model[]{contentType});
        }
        if (content instanceof CoursePart) {
            return new ImportCoursePartValuesExtractor(contentElement, this, component, context, new Model[]{contentType});
        }
        return new ImportCDMFrValuesExtractor(contentElement, this, component, context, new Model[]{contentType});
    }

    public ModelAwareValuesExtractor getMentionValuesExtractor(Element contentElement, ImportCDMFrComponent component, ImportCDMFrContext context) {
        ContentType contentType = (ContentType)this._contentTypeExtensionPoint.getExtension(ContentWorkflowDescription.PROGRAM_WF_DESCRIPTION.getContentType());
        return new ImportCDMFrValuesExtractor(contentElement, this, component, context, new Model[]{contentType});
    }

    public ModelAwareValuesExtractor getSharedSubProgramValuesExtractor(Element contentElement, ImportCDMFrComponent component, ImportCDMFrContext context) {
        ContentType contentType = (ContentType)this._contentTypeExtensionPoint.getExtension(ContentWorkflowDescription.SUBPROGRAM_WF_DESCRIPTION.getContentType());
        return new ImportCDMFrValuesExtractor(contentElement, this, component, context, new Model[]{contentType});
    }

    public AmetysObjectResolver getAmetysObjectResolver() {
        return this._resolver;
    }

    public ContentTypeExtensionPoint getContentTypeExtensionPoint() {
        return this._contentTypeExtensionPoint;
    }

    public OdfReferenceTableHelper getODFReferenceTableHelper() {
        return this._odfRefTableHelper;
    }
}

