/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.generic.scc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public abstract class AbstractMappingHelper
extends AbstractLogEnabled
implements Serviceable,
Configurable {
    protected SourceResolver _srcResolver;
    protected String _implementationName;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._implementationName = configuration.getChild("name").getValue();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    protected Map<String, String> _readMapping(String baseUri) {
        return this._parseMapping("context://WEB-INF/param/odf/" + this._implementationName + baseUri).or(() -> this._parseMapping("plugin:odf-sync://conversions/" + this._implementationName + baseUri)).orElseGet(Map::of);
    }

    private Optional<Map<String, String>> _parseMapping(String uri) {
        Source source = null;
        try {
            source = this._srcResolver.resolveURI(uri);
            if (source.exists()) {
                Optional<Map<String, String>> optional = Optional.of(this._parseMappingFile(source));
                return optional;
            }
            this.getLogger().debug("No mapping at '{}'.", (Object)uri);
        }
        catch (IOException | ConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to read the mapping file '" + uri + "'", e);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occured while parsing the mapping file '" + uri + "'", e);
        }
        finally {
            this._srcResolver.release(source);
        }
        return Optional.empty();
    }

    protected Map<String, String> _parseMappingFile(Source source) throws Exception {
        HashMap<String, String> mapping = new HashMap<String, String>();
        try (InputStream is = source.getInputStream();){
            Configuration configuration = new DefaultConfigurationBuilder().build(is);
            for (Configuration itemConf : configuration.getChildren()) {
                String remoteValue = itemConf.getAttribute("code");
                String ametysValue = itemConf.getValue();
                mapping.put(remoteValue, ametysValue);
            }
        }
        return mapping;
    }
}

