/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.scc.operator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.plugins.contentio.synchronize.impl.DefaultSynchronizingContentOperator;
import org.ametys.plugins.odfsync.scc.operator.ODFSynchronizingContentOperatorHelper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractODFSynchronizingContentOperator
extends DefaultSynchronizingContentOperator
implements Serviceable {
    protected ODFSynchronizingContentOperatorHelper _odfSCCOperatorHelper;
    protected ContentTypeExtensionPoint _contentTypeEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfSCCOperatorHelper = (ODFSynchronizingContentOperatorHelper)((Object)manager.lookup(this.getHelperRole()));
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    protected abstract String getHelperRole();

    public Map<String, List<Object>> transform(ContentType contentType, Map<String, List<Object>> remoteValues, Logger logger) {
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        for (String attributePath : remoteValues.keySet()) {
            List<Object> values = remoteValues.get(attributePath);
            if (values == null) continue;
            List<Object> transformedValues = new ArrayList<Object>(values);
            if (contentType.hasModelItem(attributePath)) {
                ModelItem modelItem = contentType.getModelItem(attributePath);
                transformedValues = this._transformAttributeValues(modelItem, transformedValues, logger);
            }
            result.put(attributePath, transformedValues);
        }
        return result;
    }

    protected List<Object> _transformAttributeValues(ModelItem definition, List<Object> values, Logger logger) {
        if (definition instanceof ContentAttributeDefinition) {
            ContentAttributeDefinition contentAttributeDef = (ContentAttributeDefinition)definition;
            return this._transformContentAttributeValues(contentAttributeDef, values, logger);
        }
        if ("rich-text".equals(definition.getType().getId())) {
            return this._transformRichTextAttributeValues((ElementDefinition)definition, values, logger);
        }
        return values;
    }

    protected List<Object> _transformContentAttributeValues(ContentAttributeDefinition definition, List<Object> values, Logger logger) {
        if (((ContentType)this._contentTypeEP.getExtension(definition.getContentTypeId())).isReferenceTable()) {
            return values.stream().filter(String.class::isInstance).map(String.class::cast).map(v -> this._getReferenceTableEntryId(definition, (String)v, logger)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return values;
    }

    protected String _getReferenceTableEntryId(ContentAttributeDefinition definition, String value, Logger logger) {
        String referenceTableEntryId = this._odfSCCOperatorHelper.getReferenceTableEntryId(definition.getContentTypeId(), value);
        if (referenceTableEntryId == null) {
            logger.warn("The connector code '{}' doesn't have a corresponding Ametys value for attribute '{}'", (Object)value, (Object)definition.getPath());
        }
        return referenceTableEntryId;
    }

    protected List<Object> _transformRichTextAttributeValues(ElementDefinition definition, List<Object> values, Logger logger) {
        String concatenated = values.stream().filter(Objects::nonNull).map(Object::toString).filter(StringUtils::isNotBlank).collect(Collectors.joining("\r\n"));
        return List.of(concatenated);
    }

    protected String _getFirstValueAsString(List<Object> values) {
        return Optional.ofNullable(values).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(Object::toString).filter(StringUtils::isNotEmpty).findFirst().orElse(null);
    }
}

