/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool allows to see items from an external datasource, in order to import them.
 */
Ext.define('Ametys.plugins.odfsync.apogee.SubProgramSearchTool', {
    extend: 'Ametys.plugins.odfsync.apogee.ApogeeFilledSearchTool',
    
    _fillSearchFields: function(syncCode)
    {
    	if (this._parent != null && syncCode != null && Ext.Array.contains(this._parent.getParameters().types, "org.ametys.plugins.odf.Content.program"))
    	{
    		var splitCodes = syncCode.split("-");
            var form = this.form.getForm();
            form.findField("dip").setValue(splitCodes[0]);
            form.findField("vdi").setValue(splitCodes[1]);
        }
    }
});
