/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.slf4j.Logger;

import org.ametys.cms.repository.Content;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.plugins.odfsync.apogee.scc.AbstractApogeeSynchronizableContentsCollection;

/**
 * SCC for orgunit contents.
 */
public class OrgUnitSynchronizableContentsCollection extends AbstractApogeeSynchronizableContentsCollection
{
    /** SCC model id */
    public static final String MODEL_ID = "org.ametys.plugins.odfsync.apogee.scc.orgunit";
    
    /** Root org unit provider */
    protected RootOrgUnitProvider _rootOrgUnitProvider;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _rootOrgUnitProvider = (RootOrgUnitProvider) manager.lookup(RootOrgUnitProvider.ROLE);
    }
    
    @Override
    protected List<Map<String, Object>> _search(Map<String, Object> searchParameters, Logger logger)
    {
        return _convertBigDecimal(_apogeeDAO.searchOrgUnits(getDataSourceId(), getParameterValues(), searchParameters));
    }

    @Override
    protected String getMappingName()
    {
        return "orgunit";
    }
    
    @Override
    protected Set<String> getNotSynchronizedRelatedContentIds(Content content, Map<String, Object> contentValues, Map<String, Object> additionalParameters, String lang, Logger logger)
    {
        Set<String> contentIds = super.getNotSynchronizedRelatedContentIds(content, contentValues, additionalParameters, lang, logger);
        
        OrgUnit rootOrgUnit = _rootOrgUnitProvider.getRoot();
        contentIds.add(rootOrgUnit.getId());
        
        return contentIds;
    }
    
    @Override
    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger)
    {
        Map<String, Object> result = super.getAdditionalAttributeValues(idValue, content, additionalParameters, create, logger);
        
        OrgUnit rootOrgUnit = _rootOrgUnitProvider.getRoot();
        result.put(OrgUnit.PARENT_ORGUNIT, rootOrgUnit);
        
        return result;
    }
    
    @Override
    protected String getChildrenAttributeName()
    {
        return OrgUnit.CHILD_ORGUNITS;
    }
}
