/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfsync.apogee.scc.AbstractApogeeSynchronizableContentsWithCatalogCollection;

/**
 * SCC for subprogram contents.
 */
public class SubProgramSynchronizableContentsCollection extends AbstractApogeeSynchronizableContentsWithCatalogCollection
{
    /** SCC model id */
    public static final String MODEL_ID = "org.ametys.plugins.odfsync.apogee.scc.subprogram";
    
    @Override
    protected List<Map<String, Object>> _search(Map<String, Object> searchParams, Logger logger)
    {
        return _convertBigDecimal(_apogeeDAO.searchSubPrograms(getDataSourceId(), getParameterValues(), searchParams));
    }

    @Override
    protected String getMappingName()
    {
        return "subprogram";
    }
    
    @Override
    protected Pair<String, Object> getParentAttribute(ModifiableContent parent)
    {
        if (parent instanceof TraversableProgramPart)
        {
            return Pair.of(ProgramPart.PARENT_PROGRAM_PARTS, new ModifiableContent[] {parent});
        }

        return super.getParentAttribute(parent);
    }
    
    @Override
    protected String getChildrenAttributeName()
    {
        return TraversableProgramPart.CHILD_PROGRAM_PARTS;
    }
}
