/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.transformers;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.plugins.odfsync.cdmfr.transformers.CDMFrSyncTransformer;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DefaultCDMFrSyncTransformer
implements CDMFrSyncTransformer,
Serviceable,
Configurable {
    public static final Map<String, String> DEFAULT_NAMESPACES = new HashMap<String, String>();
    protected DOMParser _domParser;
    protected SourceResolver _sourceResolver;
    protected XPathProcessor _xPathProcessor;
    protected String _xslFile;
    protected Set<Pattern> _applications = new HashSet<Pattern>();
    protected PrefixResolver _prefixResolver;
    protected Integer _priority;

    public void service(ServiceManager manager) throws ServiceException {
        this._domParser = (DOMParser)manager.lookup(DOMParser.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._xPathProcessor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] applications;
        for (Configuration application : applications = configuration.getChildren("app")) {
            this._applications.add(Pattern.compile(application.getValue(), 32));
        }
        this._xslFile = configuration.getChild("configuration").getChild("xsl-transform").getValue("");
        this._priority = configuration.getChild("priority").getValueAsInteger(50);
        this.configureNamespaces(configuration.getChild("namespaces", false));
    }

    protected void configureNamespaces(Configuration configuration) {
        Map<String, String> namespaces = DEFAULT_NAMESPACES;
        if (configuration != null) {
            namespaces = new HashMap<String, String>();
            for (Configuration nsConf : configuration.getChildren("namespace")) {
                String prefix = nsConf.getAttribute("prefix", "");
                String namespace = nsConf.getAttribute("value", "");
                namespaces.put(prefix, namespace);
            }
        }
        this._prefixResolver = new CDMFrPrefixResolver(namespaces);
    }

    public boolean supports(Document document) {
        String application = this._xPathProcessor.evaluateAsString((Node)document, "/cdm:CDM/cdm:properties/cdm:datasource", this._prefixResolver);
        if (StringUtils.isNotBlank((CharSequence)application)) {
            for (Pattern pattern : this._applications) {
                if (!pattern.matcher(application).matches()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Document transform(Document document, Map<String, Object> parameters) throws IOException, SAXException, ProcessingException {
        parameters.put("source", document);
        parameters.put("xslFile", this._xslFile);
        Source src = this._sourceResolver.resolveURI("cocoon://_plugins/odf-sync/cdmfr/import/file", null, parameters);
        return SourceUtil.toDOM((Source)src);
    }

    public int getPriority() {
        return this._priority;
    }

    static {
        DEFAULT_NAMESPACES.put("cdm", "http://cdm-fr.fr/2011/CDM");
        DEFAULT_NAMESPACES.put("cdmfr", "http://cdm-fr.fr/2011/CDM-frSchema");
    }

    public static class CDMFrPrefixResolver
    implements PrefixResolver {
        private Map<String, String> _namespaces;

        public CDMFrPrefixResolver(Map<String, String> namespaces) {
            this._namespaces = namespaces;
        }

        public String prefixToNamespace(String prefix) {
            return this._namespaces.get(prefix);
        }
    }
}

