/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.pegase.ws;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class PegaseTokenManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = PegaseTokenManager.class.getName();
    protected JSONUtils _jsonUtils;
    private String _token;
    private Instant _expirationDate;
    private boolean _isActive;
    private String _username;
    private String _password;
    private String _authUrl;

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public void initialize() throws Exception {
        this._isActive = (Boolean)Config.getInstance().getValue("pegase.activate", true, (Object)false);
        if (this._isActive) {
            this._authUrl = HttpUtils.sanitize((String)((String)Config.getInstance().getValue("pegase.auth.url")));
            this._username = (String)Config.getInstance().getValue("pegase.api.username");
            this._password = (String)Config.getInstance().getValue("pegase.api.password");
        }
    }

    public synchronized String getToken() throws IOException {
        if (!this._isActive) {
            throw new UnsupportedOperationException("P\u00e9gase is not active in the configuration, you cannot request a token.");
        }
        if (this._expirationDate == null || Instant.now().isAfter(this._expirationDate)) {
            CloseableHttpClient httpClient = this._getHttpClient();
            ArrayList<BasicNameValuePair> urlParams = new ArrayList<BasicNameValuePair>();
            urlParams.add(new BasicNameValuePair("username", this._username));
            urlParams.add(new BasicNameValuePair("password", this._password));
            urlParams.add(new BasicNameValuePair("token", "true"));
            HttpPost postRequest = new HttpPost(this._authUrl);
            postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParams, "UTF-8"));
            postRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
            this._token = this._executeHttpRequest(httpClient, (HttpUriRequest)postRequest);
            this._expirationDate = this._extractExpirationDate();
        }
        return this._token;
    }

    protected Instant _extractExpirationDate() {
        String[] splitToken = this._token.split("\\.");
        if (splitToken.length < 2) {
            this.getLogger().error("Invalid token format, cannot get the expiration date. The token will be reset at each API call.");
            return null;
        }
        String playload = splitToken[1];
        Base64.Decoder decoder = Base64.getUrlDecoder();
        byte[] decodedToken = decoder.decode(playload);
        String decodedTokenString = new String(decodedToken, StandardCharsets.UTF_8);
        Map map = this._jsonUtils.convertJsonToMap(decodedTokenString);
        Long expirationDateInSeconds = Long.parseLong(map.get("exp").toString());
        return Instant.ofEpochSecond(expirationDateInSeconds);
    }

    private CloseableHttpClient _getHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).useSystemProperties().build();
    }

    private String _executeHttpRequest(CloseableHttpClient httpClient, HttpUriRequest httpRequest) throws IOException {
        httpRequest.setHeader("accept", "application/json");
        try (CloseableHttpResponse httpResponse = httpClient.execute(httpRequest);){
            String string;
            block14: {
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine.getStatusCode() / 100 != 2) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                HttpEntity entity = httpResponse.getEntity();
                if (entity == null) {
                    throw new IOException("The response entity is empty.");
                }
                InputStream is = entity.getContent();
                try {
                    string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return string;
        }
    }
}

