/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.scc;

import java.util.List;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.plugins.contentio.synchronize.impl.LDAPSynchronizableContentsCollection;
import org.ametys.runtime.config.Config;

/**
 * Class to import ODF persons. Import a person only in one language.
 *
 */
public class PersonSynchronizableContentsCollection extends LDAPSynchronizableContentsCollection
{
    /** Default language configured for ODF */
    protected String _odfLang;

    @Override
    protected void configureDataSource(Configuration configuration) throws ConfigurationException
    {
        super.configureDataSource(configuration);
        _odfLang = Config.getInstance().getValue("odf.programs.lang");
    }
    
    @Override
    public List<String> getLanguages()
    {
        return List.of(_odfLang);
    }
    
    @Override
    public boolean handleRightAssignmentContext()
    {
        // Rights on ODF contents are handled by ODFRightAssignmentContext
        return false;
    }
}
