/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.pegase.ws;

import fr.pcscol.pegase.odf.ApiException;
import fr.pcscol.pegase.odf.api.EspacesExterneApi;
import fr.pcscol.pegase.odf.externe.model.Espace;
import fr.pcscol.pegase.odf.externe.model.Pageable;
import fr.pcscol.pegase.odf.externe.model.PagedEspaces;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.plugins.odfsync.pegase.ws.PegaseApiManager;
import org.ametys.plugins.odfsync.pegase.ws.PegaseExportException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class PegaseHelper
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = PegaseHelper.class.getName();
    private static final String __CACHE_ID = PegaseHelper.class.getName() + "$pegaseEspaces";
    private static final String __PEGASE_CODE_FOR_MAPPING = "codePegase";
    private PegaseApiManager _pegaseApiManager;
    private AbstractCacheManager _cacheManager;
    private UUID _espaceId;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._pegaseApiManager = (PegaseApiManager)((Object)manager.lookup(PegaseApiManager.ROLE));
    }

    public void initialize() throws Exception {
        if (!this._cacheManager.hasCache(__CACHE_ID)) {
            this._cacheManager.createMemoryCache(__CACHE_ID, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_CACHE_PEGASE_ESPACES_LABEL"), new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_CACHE_PEGASE_ESPACES_DESCRIPTION"), true, null);
        }
    }

    public UUID getEspaceId(String structureCode) throws PegaseExportException {
        if (this._espaceId == null) {
            String espaceCode = (String)Config.getInstance().getValue("pegase.espace.code");
            try {
                this._espaceId = this.getEspaceIdByCode(structureCode, espaceCode);
                if (this._espaceId == null) {
                    throw new PegaseExportException("No P\u00e9gase working space was found with the given code: '" + espaceCode + "'.");
                }
            }
            catch (ApiException | IOException e) {
                throw new PegaseExportException("An error occured while trying to retrieve the pegase working space.", e);
            }
        }
        return this._espaceId;
    }

    private synchronized void _lazyInitialize(String structureCode) throws ApiException, IOException {
        EspacesExterneApi espacesExterneApi = this._pegaseApiManager.getEspacesExterneApi();
        PagedEspaces pagedEspaces = this._getAndCachePagedEspaces(0, structureCode, espacesExterneApi);
        int nbOfPages = pagedEspaces.getTotalPages();
        for (int pageIndex = 1; pageIndex < nbOfPages; ++pageIndex) {
            this._getAndCachePagedEspaces(pageIndex, structureCode, espacesExterneApi);
        }
    }

    private PagedEspaces _getAndCachePagedEspaces(int page, String structureCode, EspacesExterneApi espacesExterneApi) throws ApiException {
        Pageable pageable = new Pageable();
        pageable.setPage(Integer.valueOf(page));
        pageable.setTaille(Integer.valueOf(Integer.MAX_VALUE));
        PagedEspaces pagedEspaces = espacesExterneApi.rechercherEspaces(structureCode, pageable, null, null, Boolean.valueOf(true));
        List espaces = pagedEspaces.getItems();
        Cache cache = this._cacheManager.get(__CACHE_ID);
        for (Espace espace : espaces) {
            cache.put((Object)espace.getCode(), (Object)espace.getId());
        }
        return pagedEspaces;
    }

    public Map<String, UUID> getEspaceIdsByCodes() {
        return this._cacheManager.get(__CACHE_ID).asMap();
    }

    public UUID getEspaceIdByCode(String structureCode, String code) throws ApiException, IOException {
        if (!this._cacheManager.get(__CACHE_ID).isInitialized()) {
            this._lazyInitialize(structureCode);
        }
        return (UUID)this._cacheManager.get(__CACHE_ID).get((Object)code);
    }

    public String _getPegaseCodeOrCode(Content content) {
        return content.hasValue(__PEGASE_CODE_FOR_MAPPING) ? (String)content.getValue(__PEGASE_CODE_FOR_MAPPING) : (String)content.getValue("code");
    }

    public String getPegaseCodeForField(Content content, String dataPath) {
        return this._getPegaseCodes(content, dataPath).collect(Collectors.joining(","));
    }

    public String getPegaseCodeForFirstValue(Content content, String dataPath) {
        return this._getPegaseCodes(content, dataPath).findFirst().orElse(null);
    }

    private Stream<String> _getPegaseCodes(Content content, String dataPath) {
        if (content.hasValue(dataPath)) {
            ContentValue[] contentValueArray;
            if (content.isMultiple(dataPath)) {
                contentValueArray = (ContentValue[])content.getValue(dataPath);
            } else {
                ContentValue[] contentValueArray2 = new ContentValue[1];
                contentValueArray = contentValueArray2;
                contentValueArray2[0] = (ContentValue)content.getValue(dataPath);
            }
            ContentValue[] values = contentValueArray;
            return Stream.of(values).map(ContentValue::getContentIfExists).filter(Optional::isPresent).map(Optional::get).map(this::_getPegaseCodeOrCode).filter(StringUtils::isNotEmpty);
        }
        return Stream.of(new String[0]);
    }
}

