/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that opens/closes a tool.
 * Unique instance tool state will be reflected the open/close status by beeing toggled or not.
 */
Ext.define(
    "Ametys.plugins.odfsync.apogee.ApogeeOpenToolButtonController",
    {
        extend: "Ametys.ribbon.element.ui.button.OpenToolButtonController",

        constructor: function(config)
        {
            config.action = "Ametys.plugins.odfsync.apogee.ApogeeOpenToolButtonController._act";
            this.callParent(arguments);
        },
    
        statics: {
            /**
             * @private
             * Called when the button is clicked
             * @param {Ametys.plugins.odfsync.apogee.ApogeeOpenToolButtonController} button The button controller instance
             */
            _act: function (button)
            {
                var toolId = button.getInitialConfig("opentool-id");
                var parameters = button.getInitialConfig("opentool-params") || {};
                
                Ametys.tool.ToolsManager.openTool(toolId, parameters);
            }
        }
    }
);

