<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdm="http://cdm-fr.fr/2013/CDM"
    xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
    xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
    exclude-result-prefixes="cdm cdmfr ametys-cdm">
    
    <xsl:template name="course-syllabus" priority="2">
        <syllabus>
            <xsl:if test="cdm:syllabus/*[not(local-name() = 'bibliography') or not(local-name()='webLink' and @role='learningObjectMetadata')]">
                <xsl:apply-templates select="cdm:syllabus[*]" mode="infoblock"/>
            </xsl:if>
        </syllabus>
        <xsl:if test="cdm:syllabus/cdm:webLink[@role='learningObjectMetadata']">
            <lomSheets>
                <xsl:for-each select="cdm:syllabus/cdm:webLink[@role='learningObjectMetadata']">
                    <item name="{position()}">
                        <linkUrl><xsl:value-of select="cdm:href"/></linkUrl>
                        <linkLabel><xsl:value-of select="cdm:linkName"/></linkLabel>
                    </item>
                </xsl:for-each>
            </lomSheets>
        </xsl:if>
    </xsl:template>
    
    <!-- Bibliography -->
    <xsl:template name="course-bibliography">
        <bibliography>
            <xsl:if test="cdm:syllabus/ametys-cdm:bibliography/*">
                <xsl:apply-templates select="cdm:syllabus/ametys-cdm:bibliography[*]" mode="infoblock"/>
            </xsl:if>
        </bibliography>
    </xsl:template>
    
    <!-- Objectifs -->
    <xsl:template name="course-objectives" priority="2">
        <objectives>
            <xsl:if test="cdm:learningObjectives/*[not(local-name() = 'skills')]">
                <xsl:apply-templates select="cdm:learningObjectives[*]" mode="infoblock"/>
            </xsl:if>
        </objectives>
    </xsl:template>
    
    <!-- Compétences visées -->
    <xsl:template name="course-skills">
        <skills>
            <xsl:if test="cdm:learningObjectives/ametys-cdm:skills/*">
                <xsl:apply-templates select="cdm:learningObjectives/ametys-cdm:skills[*]" mode="infoblock"/>
            </xsl:if>
        </skills>
    </xsl:template>
    
    <!-- Ouvert aux étudiants étrangers -->
    <xsl:template name="course-openToExchangeStudents">
        <openToExchangeStudents><xsl:value-of select="count(cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:openToExchangeStudents) > 0"/></openToExchangeStudents>
    </xsl:template>
</xsl:stylesheet>
